﻿using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VT.FW.DB;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 财务单据仓储
    /// </summary>
    public partial class RB_FinanceRepository : RepositoryBase<RB_Finance>
    {

        /// <summary>
        /// 获取电商订单所有财务单据
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Finance_Extend> GetList(RB_Finance_Extend model)
        {
            string where = "1=1 AND A.Is_Auto=0 ";
            where += string.Format(" AND A." + nameof(RB_Finance.Status) + " <> 4");
            where += string.Format(" AND E." + nameof(RB_Finance.Status) + " <> 4");
            //集团
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RB_Group_Id) + " ={0}", model.RB_Group_Id);
            }
            //单据状态
            if (model.Status >= 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Status) + " ={0}", (int)model.Status);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.Type) + " ={0}", (int)model.Type);
            }
            //订单号
            if (model.OrderID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.OrderID) + " ={0}", model.OrderID);
            }
            //对象类型
            if (model.ClientType > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientType) + " ={0}", (int)model.ClientType);
            }
            //汇款人
            if (!string.IsNullOrEmpty(model.RemitterName))
            {
                where += string.Format(" AND A." + nameof(RB_Finance.RemitterName) + " like '%{0}%' ", model.RemitterName);
            }
            //付款对象
            if (model.ClientID > 0)
            {
                where += string.Format(" AND A." + nameof(RB_Finance.ClientID) + " ={0}", model.ClientID);
            }

            if (model.ECOrderId > 0) {
                where += string.Format(" AND E." + nameof(RB_ECFinanceId_Relation.ECOrderId) + " ={0}", model.ECOrderId);
            }
            if (!string.IsNullOrEmpty(model.ECOrderIds)) {
                where += string.Format(" AND E." + nameof(RB_ECFinanceId_Relation.ECOrderId) + " in({0})", model.ECOrderIds);
            }

            string sql = $@"
select A.FrID,A.Status,A.Type,E.ECOrderId,E.ECOrderDetailId from RB_Finance A 
inner join RB_ECFinanceId_Relation E on A.FrID = E.FinanceId
where {where} order by FrID desc
";
            return Get<RB_Finance_Extend>(sql).ToList();
        }

        
    }
}
