﻿using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 银行
    /// </summary>
    public class RB_BackAccountRepository : RepositoryBase<RB_BackAccount>
    {
        /// <summary>
        /// 获取账户列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_BackAccount_Extend> GetAccountList(RB_BackAccount_Extend model)
        {
            string where = " where 1=1 ";
            if (model.ID > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.ID) + " ={0}", model.ID);
            }
            if (model.BackId > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.BackId) + " ={0}", model.BackId);
            }
            if (model.TypeId > 0)
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.TypeId) + " ={0}", model.TypeId);
            }
            if (model.BankType > 0) {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.BankType) + " ={0}", model.BankType);
            }
            if (!string.IsNullOrEmpty(model.Alias))
            {
                where += string.Format(" AND t." + nameof(RB_BackAccount_Extend.Alias) + " like '%{0}%' ", model.Alias);
            }
            if (model.BranchId.HasValue && model.BranchId >= 0) {
                where += $@" and al.RB_Branch_Id={model.BranchId}";
            }
            string sql = string.Format(@"select distinct t.ID,t.Alias,t.BackNo,t.CurrencyId,t.AccountType as AccountTypeName,t.backId,t.TypeId,t.BankType,t.CreateBy,t.CreateDate,t.CurrencyName,t.Rate,t.Initialbalance from ( 
 SELECT ID,Alias,backNo AS BackNo,CurrencyId,'银行' as AccountType,backId,TypeId,1 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT (IFNULL(CurrentRate,0)+IFNULL(ExchangeRates,0)) as CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_backaccount as A where `Status`=0 and RB_Group_Id={0}
 UNION ALL
 SELECT ID,Alias,PlatformNo AS BackNo,CurrencyId,'平台' as AccountType,BackId as backId,TypeId,2 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT (IFNULL(CurrentRate,0)+IFNULL(ExchangeRates,0)) as CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_platformaccount as A where `Status`=0 and RB_Group_Id={0}
 UNION ALL 
 SELECT ID,Alias,'' AS BackNo,CurrencyId,'现金' as AccountType,0 as backId,TypeId,3 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT (IFNULL(CurrentRate,0)+IFNULL(ExchangeRates,0)) as CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_cashaccount as A where `Status`=0 and RB_Group_Id={0}
 UNION ALL 
 SELECT ID,Alias,'' AS BackNo,CurrencyId,'资金池' as AccountType,0 as backId,TypeId,4 as BankType,CreateBy,CreateDate,(SELECT `Name` from rb_currency where ID=currencyId ) as CurrencyName,IFNULL((SELECT (IFNULL(CurrentRate,0)+IFNULL(ExchangeRates,0)) as CurrentRate from rb_currency where ID=currencyId) ,0)as Rate,Initialbalance FROM rb_cashpoolaccount as A where `Status`=0  and RB_Group_Id={0}
)as t
left join rb_accountrelation al on t.BankType=al.AccountType and t.ID=al.AccountID and al.Type=2 and al.Status=0
{1} {2}", model.RB_Group_Id, where, " order by t.ID asc ");
            return Get<RB_BackAccount_Extend>(sql).ToList();
        }
    }
}
