﻿using System;
using System.Collections.Generic;

namespace DapperExtensions
{
    /// <summary>
    /// 多谓词支持
    /// </summary>
    public class GetMultiplePredicate
    {
        private readonly List<GetMultiplePredicateItem> _items;

        /// <summary>
        /// 构造函数
        /// </summary>
        public GetMultiplePredicate()
        {
            _items = new List<GetMultiplePredicateItem>();
        }

        /// <summary>
        /// 多谓词项
        /// </summary>
        public IEnumerable<GetMultiplePredicateItem> Items
        {
            get { return _items.AsReadOnly(); }
        }

        /// <summary>
        /// 多谓词项
        /// </summary>
        public class GetMultiplePredicateItem
        {
            /// <summary>
            /// 值
            /// </summary>
            public object Value { get; set; }

            /// <summary>
            /// 类型
            /// </summary>
            public Type Type { get; set; }

            /// <summary>
            /// 排序接口
            /// </summary>
            public IList<ISort> Sort { get; set; }
        }
    }
}