﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 单据交易方式实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_TradeWay
    {
        /// <summary>
        /// 主键
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 单据ID
        /// </summary>        
        public int? FinanceId
        {
            get;
            set;
        }
        /// <summary>
        /// 币种ID
        /// </summary>
        public int? CurrencyId
        {
            get; set;
        }
        /// <summary>
        /// 原币金额
        /// </summary>        
        public decimal? OriginalMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 汇率
        /// </summary>        
        public decimal? Rate
        {
            get;
            set;
        }
        /// <summary>
        /// 本币金额
        /// </summary>        
        public decimal? Money
        {
            get;
            set;
        }

        /// <summary>
        ///见枚举账户分类
        /// </summary>        
        public Common.Enum.Finance.BranchAccountEnum? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 账户ID
        /// </summary>        
        public int? AccountId
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public Common.Enum.DateStateEnum Status
        {
            get;
            set;
        }
        /// <summary>
        /// 说明
        /// </summary>
        public string Description { get; set; }
        /// <summary>
        /// 调拨日期
        /// </summary>
        public DateTime? AllotDate { get; set; }

        /// <summary>
        /// 调拨方式   1收款  2付款
        /// </summary>
        public int? AllotType { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int? Sort { get; set; }
        /// <summary>
        /// 是否是汇兑损益  1是  0否
        /// </summary>
        public int? IsExChange { get; set; }
    }
}
