﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Miai;

namespace Mall.Repository.Miai
{
    public class RB_MiAi_DianZanRepository : BaseRepository<RB_MiAi_DianZan>
    {


        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_MiAi_DianZan); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_MiAi_DianZan_Extend> GetDianZanList(RB_MiAi_DianZan_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,u.Name as UserName,u.Photo from RB_MiAi_DianZan as a 
LEFT JOIN rb_member_user as u on a.CreateBy=u.Id  where 1=1");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.ID={0}", where.ID);
                }
                if (where.CreateBy > 0)
                {
                    sb.AppendFormat(" and a.CreateBy={0}", where.CreateBy);
                }
                if (where.IsSelectActivity > 0)
                {
                    if (where.IsSelectActivity == 1)
                    {
                        sb.AppendFormat(" and a.ActivityId={0} and a.ActivityDiscussId=0", where.ActivityId);
                    }
                    else if (where.IsSelectActivity == 2)
                    {
                        sb.AppendFormat(" and a.ActivityId={0} and a.ActivityDiscussId={1}", where.ActivityId,where.ActivityDiscussId);
                    }
                }
                if (!string.IsNullOrEmpty(where.ActivityIds))
                {
                    sb.AppendFormat($@" and a.{nameof(RB_MiAi_DianZan.ActivityId)} in({where.ActivityIds})");
                }

                if (where.Status >= 0)
                {
                    sb.AppendFormat($" AND a.{nameof(RB_MiAi_DianZan.Status)}={where.Status}");
                }
            }
            return Get<RB_MiAi_DianZan_Extend>(sb.ToString()).ToList();
        }
    }
}
