﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 榜单仓储层
    /// </summary>
    public class RB_FirstShop_ListRepository : BaseRepository<RB_FirstShop_List>
    {
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_FirstShop_List_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_FirstShop_List_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and Status =0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ListType > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListType)}={(int)dmodel.ListType}";
            }
            if (dmodel.ObjectTypeId > 0)
            {
                where += $@" and find_in_set('{dmodel.ObjectTypeId}',w.{nameof(RB_FirstShop_List_Extend.ObjectTypeIds)})";
            }
            if (dmodel.ListState > 0)
            {
                if (dmodel.ListState == Common.Enum.TradePavilion.ListStateEnum.NotStarted) {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)Common.Enum.TradePavilion.ListStateEnum.Enroll}";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.StartDate)} >'{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                }
                else if (dmodel.ListState == Common.Enum.TradePavilion.ListStateEnum.Enroll)
                {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)Common.Enum.TradePavilion.ListStateEnum.Enroll}";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.StartDate)} <='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.EndDate)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                }
                else if (dmodel.ListState == Common.Enum.TradePavilion.ListStateEnum.Rating)
                {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)Common.Enum.TradePavilion.ListStateEnum.Enroll}";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.EndDate)} <'{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                }
                else {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)dmodel.ListState}";
                }
            }
            if (!string.IsNullOrEmpty(dmodel.Sponsor))
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.Sponsor)} @Sponsor";
                parameters.Add("Sponsor", "%" + dmodel.Sponsor + "%");
            }
            if (!string.IsNullOrEmpty(dmodel.ListName))
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListName)} @ListName";
                parameters.Add("ListName", "%" + dmodel.ListName + "%");
            }
            if (dmodel.IsAppletSelectNor == 1) {
                //小程序端查询
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)} <>{(int)Common.Enum.TradePavilion.ListStateEnum.Cancel}";
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.StartDate)} <='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
            }
            if (dmodel.Year > 0)
            {
                where += $@" and (YEAR(w.{nameof(RB_FirstShop_List_Extend.StartDate)})={dmodel.Year} or YEAR(w.{nameof(RB_FirstShop_List_Extend.EndDate)})={dmodel.Year})";
            }

            string orderBy = " order by w.Id desc";
            if (dmodel.OrderBy == 1) {
                orderBy = " order by w.EndDate desc";//根据报名截止日期
            }

            string sql = $@"select w.* from RB_FirstShop_List w
where {where} {orderBy}
";
            return GetPage<RB_FirstShop_List_Extend>(pageIndex, pageSize, out count, sql, parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_FirstShop_List_Extend> GetList(RB_FirstShop_List_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and Status =0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ListIds))
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.Id)} in({dmodel.ListIds})";
            }
            if (dmodel.ListType > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListType)}={(int)dmodel.ListType}";
            }
            if (dmodel.ObjectTypeId > 0)
            {
                where += $@" and find_in_set('{dmodel.ObjectTypeId}',w.{nameof(RB_FirstShop_List_Extend.ListType)})";
            }
            if (!string.IsNullOrWhiteSpace(dmodel.QIds))
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.Id)} in ({dmodel.QIds})";
            }
            if (dmodel.ListState > 0)
            {
                if (dmodel.ListState == Common.Enum.TradePavilion.ListStateEnum.Enroll)
                {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)Common.Enum.TradePavilion.ListStateEnum.Enroll}";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.StartDate)} >='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.EndDate)} <='{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                }
                else if (dmodel.ListState == Common.Enum.TradePavilion.ListStateEnum.Rating)
                {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)Common.Enum.TradePavilion.ListStateEnum.Enroll}";
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.EndDate)} <'{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}'";
                }
                else
                {
                    where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListState)}={(int)dmodel.ListState}";
                }
            }
            if (!string.IsNullOrEmpty(dmodel.Sponsor))
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.Sponsor)} @Sponsor";
                parameters.Add("Sponsor", "%" + dmodel.Sponsor + "%");
            }
            if (!string.IsNullOrEmpty(dmodel.ListName))
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.ListName)} @ListName";
                parameters.Add("ListName", "%" + dmodel.ListName + "%");
            }


            string sql = $@"select w.* from RB_FirstShop_List w
where {where} order by w.Id desc
";
            return Get<RB_FirstShop_List_Extend>(sql, parameters).ToList();
        }

        /// <summary>
        /// 获取小程序 我的报名榜单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_FirstShop_List_Extend> GetAppletMyEnrollFistShopListPageList(int pageIndex, int pageSize, out long count, RB_FirstShop_List_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and w.Status =0 and e.Status =0 and w.ListState <>{(int)Common.Enum.TradePavilion.ListStateEnum.Cancel}";
            if (dmodel.TenantId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and w.{nameof(RB_FirstShop_List_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Year > 0)
            {
                where += $@" and YEAR(e.{nameof(RB_FirstShop_ListEnroll_Extend.CreateDate)})={dmodel.Year}";
            }
            if (dmodel.CreateBy > 0)
            {
                where += $@" and e.{nameof(RB_FirstShop_ListEnroll_Extend.UserId)}={dmodel.CreateBy}";
            }

            string sql = $@"select w.*,e.ObjectType,e.ObjectId,e.Rank,e.MedalImage,e.RankListState from RB_FirstShop_List w
left join rb_firstshop_listenroll e on w.Id = e.ListId
where {where} group by w.Id,e.ObjectType,e.ObjectId order by w.EndDate desc
";
            return GetPage<RB_FirstShop_List_Extend>(pageIndex, pageSize, out count, sql, parameters).ToList();
        }
    }
}