﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 活动表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_Activity
    {
        /// <summary>
        /// 活动编号(主键)
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 活动名称
        /// </summary>
        public string ActivityName { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime StartTime { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public DateTime EndTime { get; set; }

        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImg { get; set; }

        /// <summary>
        /// 活动类型(rb_commerce_activitytype表Id)
        /// </summary>
        public int? ActivityType { get; set; }

        /// <summary>
        /// 活动详情
        /// </summary>
        public string ActivityInfo { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public Common.Enum.DateStateEnum Status { get; set; }

        /// <summary>
        /// 报名开始时间
        /// </summary>
        public DateTime? SignStartTime { get; set; }

        /// <summary>
        /// 报名截止时间
        /// </summary>
        public DateTime? SignEndTime { get; set; }

        /// <summary>
        /// 是否免费   1是  2否
        /// </summary>
        public int IsFree { get; set; }

        /// <summary>
        /// 报名点数
        /// </summary>
        public int PointNum { get; set; }

        /// <summary>
        /// 报名价格
        /// </summary>
        public decimal Price { get; set; }

        /// <summary>
        /// 是否需取消确认   1是  2否
        /// </summary>
        public int IsCancelConfirm { get; set; }

        /// <summary>
        /// 标签
        /// </summary>
      //  public string Label { get; set; }



        /// <summary>
        /// 男数量
        /// </summary>
        public int ManNum { get; set; }

        /// <summary>
        /// 女数量
        /// </summary>
        public int WoManNum { get; set; }


        /// <summary>
        /// 0-区分，1-不区分报名性别
        /// </summary>
        public int Distinguish { get; set; }

        /// <summary>
        /// 年龄限制 0-区分，1-不区分报名
        /// </summary>
        public int AgeLimit { get; set; }

        /// <summary>
        /// 最小年龄
        /// </summary>
        public int StartAge { get; set; }

        /// <summary>
        /// 最大年龄
        /// </summary>
        public int EndAge { get; set; }
        /// <summary>
        /// 经纬度（逗号分隔）
        /// </summary>
        public string LonLat { get; set; }

        /// <summary>
        /// 位置名称
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// 内部限制0-否，1-是
        /// </summary>
        public int LnsideLimit { get; set; }
    }
}
