﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 微店自定义表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_SmallShops_Custom
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 头部背景图片
        /// </summary>        
        public string HeadBackImage
        {
            get;
            set;
        }


        /// <summary>
        /// 提现按钮圆角像素
        /// </summary>        
        public int? WithdrawalFilletPX
        {
            get;
            set;
        }
        /// <summary>
        /// 提现按钮文本
        /// </summary>        
        public string WithdrawalText
        {
            get;
            set;
        }
        /// <summary>
        /// 提现按钮颜色
        /// </summary>        
        public string WithdrawalColor
        {
            get;
            set;
        }
        /// <summary>
        /// 按钮文字颜色
        /// </summary>        
        public string WithdrawalTextColor
        {
            get;
            set;
        }

        /// <summary>
        /// 提现图标
        /// </summary>        
        public string WithdrawalImage
        {
            get;
            set;
        }


        /// <summary>
        /// 店铺订单名称
        /// </summary>        
        public string SmallShopOrderName
        {
            get;
            set;
        }
        /// <summary>
        /// 店铺订单图片
        /// </summary>        
        public string SmallShopOrderImage
        {
            get;
            set;
        }
        /// <summary>
        /// 提现明细
        /// </summary>        
        public string WithdrawalDetailName
        {
            get;
            set;
        }
        /// <summary>
        /// 提现明细图片
        /// </summary>        
        public string WithdrawalDetailImage
        {
            get;
            set;
        }
        /// <summary>
        /// 我的客户
        /// </summary>        
        public string MyCustomerName
        {
            get;
            set;
        }
        /// <summary>
        /// 我的客户图片
        /// </summary>        
        public string MyCustomerImage
        {
            get;
            set;
        }
        /// <summary>
        /// 店铺二维码
        /// </summary>        
        public string SmallShopQRCodeName
        {
            get;
            set;
        }
        /// <summary>
        /// 店铺二维码图片
        /// </summary>        
        public string SmallShopQRCodeImage
        {
            get;
            set;
        }
        /// <summary>
        /// 店铺设置
        /// </summary>        
        public string SmallShopSetUpName
        {
            get;
            set;
        }
        /// <summary>
        /// 店铺设置图片
        /// </summary>        
        public string SmallShopSetUpImage
        {
            get;
            set;
        }

        /// <summary>
        /// 直播名称
        /// </summary>        
        public string LiveName
        {
            get;
            set;
        }
        /// <summary>
        /// 直播图标
        /// </summary>        
        public string LiveImage
        {
            get;
            set;
        }
        /// <summary>
        /// 已提现佣金描述
        /// </summary>        
        public string CommissionWithdrawnName
        {
            get;
            set;
        }
        /// <summary>
        /// 未结算佣金描述
        /// </summary>        
        public string OutstandingCommissionName
        {
            get;
            set;
        }

        /// <summary>
        /// 可提现佣金描述
        /// </summary>        
        public string WithdrawableName
        {
            get;
            set;
        }


        ///// <summary>
        ///// 分销商描述
        ///// </summary>        
        //public string DistributorName
        //{
        //    get;
        //    set;
        //}
        /// <summary>
        /// 待打款佣金描述
        /// </summary>        
        public string CommissionTobePaidName
        {
            get;
            set;
        }
        /// <summary>
        /// 用户须知描述
        /// </summary>        
        public string UserNotesName
        {
            get;
            set;
        }

        /// <summary>
        /// 用户须知
        /// </summary>        
        public string UserNotes
        {
            get;
            set;
        }
        /// <summary>
        /// 我要提现描述
        /// </summary>        
        public string IWantToWithdrawName
        {
            get;
            set;
        }
        /// <summary>
        /// 提现金额描述
        /// </summary>        
        public string WithdrawalAmountName
        {
            get;
            set;
        }
        /// <summary>
        /// 提现方式描述
        /// </summary>        
        public string WithdrawalWayName
        {
            get;
            set;
        }

        public int Status { get; set; }

        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
