﻿using Mall.Common.Plugin;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using Mall.Repository.Education;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.Education
{
    public class EducationModule
    {
        /// <summary>
        /// 教师仓储
        /// </summary>
        private readonly RB_Education_TeacherRepository educationTeacherRepository = new RB_Education_TeacherRepository();

   
        private readonly RB_Education_CouponRepository discountCouponRepository = new RB_Education_CouponRepository();
        private readonly RB_Education_CouponProductRepository productRepository = new RB_Education_CouponProductRepository();


        private readonly RB_Education_MemberUseCouponRepository memberUseCouponRepository = new RB_Education_MemberUseCouponRepository();
        private readonly RB_Education_MemberCouponRepository memberCouponRepository = new RB_Education_MemberCouponRepository();
        private readonly RB_Education_CouponSelfMotionMemberRepository selfMotionMemberRepository = new RB_Education_CouponSelfMotionMemberRepository();

        private readonly RB_Education_CouponSelfMotionRepository selfMotionRepository = new RB_Education_CouponSelfMotionRepository();

        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();

        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Education_ArticleRepository educationArticleRepository = new RB_Education_ArticleRepository();

        #region 教师管理
        /// <summary>
        ///教师配置列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetTeacherPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Teacher_Extend query)
        {
            List<RB_Education_Teacher_Extend> list = educationTeacherRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 教师配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Education_Teacher_Extend GetTeacherModel(RB_Education_Teacher_Extend query)
        {
            RB_Education_Teacher_Extend model = educationTeacherRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        ///教师列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Education_Teacher_Extend GetTeacherOrderInfo(RB_Education_Teacher_Extend query)
        {
            RB_Education_Teacher_Extend model = educationTeacherRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        /// 教师配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Teacher_Extend> GetTeacherList(RB_Education_Teacher_Extend query)
        {
            return educationTeacherRepository.GetTeacherList(query);
        }
        /// <summary>
        /// 新增/修改教师配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateTeacher(RB_Education_Teacher_Extend model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = educationTeacherRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_Teacher_Extend.TeacherLogo),model.TeacherLogo},
                        { nameof(RB_Education_Teacher_Extend.Name),model.Name},
                        { nameof(RB_Education_Teacher_Extend.Telephone),model.Telephone},
                        { nameof(RB_Education_Teacher_Extend.Introduction),model.Introduction},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Education_Teacher_Extend.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = educationTeacherRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateTeacher");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 批量上下架教师
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableTeacherInfo(List<string> ids, int TeacherStatus, int uid, int mallBaseId)
        {
            var trans = educationTeacherRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Teacher.TeacherStatus),TeacherStatus},
                            { nameof(RB_Education_Teacher.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Teacher.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Teacher.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Teacher.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = educationTeacherRepository.Update(cols, wheres1, trans);
                    }
                }
                educationTeacherRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableTeacherInfo");
                educationTeacherRepository.DBSession.Rollback("EnableTeacherInfo");
                return false;
            }
            return flag;
        }
        #endregion


        #region 卡劵
        /// <summary>
        /// 卡劵信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_Education_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 卡劵信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetDiscountCouponList(RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetDiscountCouponList(query);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category || x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list)
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;

        }

        /// <summary>
        /// 卡劵信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetAllDiscountCouponList(RB_Education_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponList(query);

        }



        /// <summary>
        /// 新增/修改卡劵
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDiscountCoupon(RB_Education_Coupon_Extend model)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = discountCouponRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.DiscountCouponType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = discountCouponRepository.Update(model, trans);


                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Education_CouponProduct.Status),1},
                             { nameof(RB_Education_CouponProduct.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Education_CouponProduct.CouponId),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                        };
                    productRepository.Update(fileds, whereHelpers, trans);
                   
                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.DiscountCouponType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("AddOrUpdateDiscountCoupon");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除卡劵
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountCoupon(int id, int uid, int mallBaseId)
        {
            var trans = discountCouponRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_Coupon.Status),1},
                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = discountCouponRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_Coupon.Status),1},
                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponProduct.CouponId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponProduct.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponProduct.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                productRepository.Update(cols, wheres);


                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("DelDiscountCoupon");
                return false;
            }
            return flag;
        }





        /// <summary>
        /// 删除会员卡劵
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberCoupon(int id, int uid, int mallBaseId)
        {
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_MemberCoupon.Status),1},
                        { nameof(RB_Education_MemberCoupon.Remarks),System.DateTime.Now+"删除"},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_MemberCoupon.Id),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_MemberCoupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_MemberCoupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = memberCouponRepository.Update(cols1, wheres1);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelMemberCoupon");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 领劵中心
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool UpdatePickupType(int id, int uid, int mallBaseId)
        {
            try
            {
                var model = discountCouponRepository.GetEntity(id);

                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_Coupon.PickupCenter),model.PickupCenter==0?1:0},
                        { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                return discountCouponRepository.Update(cols1, wheres1);


            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdatePickupType");
                return false;
            }
        }



        /// <summary>
        /// 发放卡劵
        /// </summary>
        /// <param name="list"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool GrantCoupon(List<RB_Education_MemberCoupon_Extend> list, RB_Education_Coupon_Extend model)
        {
            var trans = memberCouponRepository.DbTransaction;
            bool flag;
            try
            {
                flag = memberCouponRepository.InsertBatch(list, trans);
                if (model != null && flag)
                {
                    Dictionary<string, object> cols1;
                    if (model.TotalNum != -1)
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},
                            { nameof(RB_Education_Coupon.TotalNum),model.TotalNum - list.Count()},
                            { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    else
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},

                            { nameof(RB_Education_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    List<WhereHelper> wheres1 = new List<WhereHelper>()
                    {
                    new WhereHelper(){
                            FiledName=nameof(RB_Education_Coupon.ID),
                            FiledValue=model.ID,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Education_Coupon.TenantId),
                            FiledValue=model.TenantId,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Education_Coupon.MallBaseId),
                            FiledValue=model.MallBaseId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                    };
                    flag = discountCouponRepository.Update(cols1, wheres1, trans);
                }
                memberCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GrantCoupon");
                memberCouponRepository.DBSession.Rollback("GrantCoupon");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 根据用户id和商品分类以及商品id获取未使用的卡劵信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetNoUseCouponList(RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetNoUseCouponList(query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }

            return list;
        }


        #endregion


        #region 自动发放优惠券规则
        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Education_CSelfMotion_Extend query)
        {
            return selfMotionRepository.GetSelfMotionPageLis(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotion_Extend> GettRepositoryList(RB_Education_CSelfMotion_Extend query)
        {
            var list = selfMotionRepository.GettRepositoryList(query);

            return list;
        }



        /// <summary>
        /// 获取发放优惠券的人员信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotionMember_Extend> GetSelfMotionMemberList(RB_Education_CSelfMotionMember_Extend query)
        {
            return selfMotionMemberRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改自动发放优惠券
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateSelfMotion(RB_Education_CSelfMotion_Extend model)
        {
            bool flag = false;
            var trans = selfMotionRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = selfMotionRepository.Insert(model, trans);
                    if (id > 0 && model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = selfMotionRepository.Update(model, trans);
                   
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Education_CouponSelfMotionMember.Status),1},
                             { nameof(RB_Education_CouponSelfMotionMember.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Education_CouponSelfMotionMember.SelfMotionId),FiledValue=model.ID,OperatorEnum=OperatorEnum.Equal},
                             new WhereHelper (){ FiledName=nameof(RB_Education_CouponSelfMotionMember.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                              new WhereHelper (){ FiledName=nameof(RB_Education_CouponSelfMotionMember.TenantId),FiledValue=model.TenantId,OperatorEnum=OperatorEnum.Equal}
                        };
                    selfMotionMemberRepository.Update(fileds, whereHelpers, trans);


                    if (model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                }
                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateSelfMotion");
                selfMotionRepository.DBSession.Rollback("AddOrUpdateSelfMotion");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除自动发放优惠券
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountSelfMotion(int id, int uid, int mallBaseId)
        {
            var trans = selfMotionRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_CouponSelfMotion.Status),1},
                        { nameof(RB_Education_CouponSelfMotion.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotion.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = selfMotionRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Education_CouponSelfMotionMember.Status),1},
                        { nameof(RB_Education_CouponSelfMotionMember.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotionMember.SelfMotionId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotionMember.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Education_CouponSelfMotionMember.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                selfMotionMemberRepository.Update(cols, wheres);


                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountSelfMotion");
                selfMotionRepository.DBSession.Rollback("DelDiscountSelfMotion");
                return false;
            }
            return flag;
        }


        #endregion


        #region 会员优惠券
        /// <summary>
        /// 我的优惠券
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Coupon_Extend> GetMemberDisCouponList(int pageIndex, int pageSize, out long rowCount, RB_Education_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetMemberDisCouponList(pageIndex, pageSize, out rowCount, query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Education_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;
        }
        #endregion

        #region  教育-资讯管理
        /// <summary>
        ///资讯配置列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_Article_Extend> GetArticlePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Education_Article_Extend query)
        {
            List<RB_Education_Article_Extend> list = educationArticleRepository.GetPageListRepository(pageIndex, pageSize, out rowCount, query);

            return list;
        }

        /// <summary>
        /// 资讯配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Education_Article_Extend GetArticleModel(RB_Education_Article_Extend query)
        {
            RB_Education_Article_Extend model = educationArticleRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        ///资讯列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Education_Article_Extend GetArticleInfo(RB_Education_Article_Extend query)
        {
            RB_Education_Article_Extend model = educationArticleRepository.GetTeacherList(query).FirstOrDefault();

            return model;
        }


        /// <summary>
        /// 资讯配置
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Article_Extend> GetArticleList(RB_Education_Article_Extend query)
        {
            return educationArticleRepository.GetTeacherList(query);
        }
        /// <summary>
        /// 新增/修改资讯配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateArticle(RB_Education_Article_Extend model)
        {
            bool flag = false;
            try
            {

                if (model.ID == 0)
                {
                    flag = educationArticleRepository.Insert(model) > 0;
                }
                else
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Education_Article_Extend.LableName),model.LableName},
                        { nameof(RB_Education_Article_Extend.Name),model.Name},
                        { nameof(RB_Education_Article_Extend.IsComment),model.IsComment},
                        { nameof(RB_Education_Article_Extend.Describe),model.Describe},
                        { nameof(RB_Education_Article_Extend.ArticleStatus),model.ArticleStatus},
                        { nameof(RB_Education_Article_Extend.DownDate),model.DownDate},
                        { nameof(RB_Education_Article_Extend.FictitiousBrowseNum),model.FictitiousBrowseNum},
                        { nameof(RB_Education_Article_Extend.ShelvesDate),model.ShelvesDate},
                        { nameof(RB_Education_Article_Extend.Sort),model.Sort},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Education_Article_Extend.ID),
                              FiledValue=model.ID,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = educationArticleRepository.Update(keyValues, wheres);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateArticle");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 批量上下架资讯
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableArticleInfo(List<string> ids, int ArticleStatus, int uid, int mallBaseId)
        {
            var trans = educationArticleRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Article.ArticleStatus),ArticleStatus},
                            { nameof(RB_Education_Article.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = educationArticleRepository.Update(cols, wheres1, trans);
                    }
                }
                educationArticleRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableArticleInfo");
                educationArticleRepository.DBSession.Rollback("EnableArticleInfo");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 批量删除资讯
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelArticleInfo(List<string> ids,  int uid, int mallBaseId)
        {
            var trans = educationArticleRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Education_Article.Status),0},
                            { nameof(RB_Education_Article.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Education_Article.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = educationArticleRepository.Update(cols, wheres1, trans);
                    }
                }
                educationArticleRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelArticleInfo");
                educationArticleRepository.DBSession.Rollback("DelArticleInfo");
                return false;
            }
            return flag;
        }
        #endregion

    }
}
