﻿ 
using System;
using System.Collections.Generic;
 

namespace Mall.AOP
{
    /// <summary>
    /// 拦截器基类
    /// </summary>
    public class IOCInterceptor : Castle.DynamicProxy.StandardInterceptor
    {
        /// <summary>
        /// 方法调用前执行
        /// </summary>
        /// <param name="invocation"></param>
        protected override void PreProceed(Castle.DynamicProxy.IInvocation invocation)
        {
            Console.WriteLine("调用前的拦截器， 方法名是: {0}", invocation.Method.Name);
        }

        /// <summary>
        /// 方法执行时调用
        /// </summary>
        /// <param name="invocation"></param>
        protected override void PerformProceed(Castle.DynamicProxy.IInvocation invocation)
        {
            var method = invocation.Method;
            Action action = () => base.PerformProceed(invocation);
            if (method.IsDefined(typeof(BaseInterceptorAttribute), true))
            {
                foreach (var attribute in method.GetCustomAttributes(typeof(BaseInterceptorAttribute), true))
                {
                    var attr = (BaseInterceptorAttribute)attribute;
                    action= attr.Do(invocation,action);
                }
            }
            action.Invoke();
            Console.WriteLine("拦截的方法返回时调用的拦截， 方法名是: {0}", invocation.Method.Name);
        }

        /// <summary>
        /// 方法执行后调用
        /// </summary>
        /// <param name="invocation"></param>
        protected override void PostProceed(Castle.DynamicProxy.IInvocation invocation)
        {
            Console.WriteLine("调用后的拦截器， 方法名是: {0}", invocation.Method.Name);
        }
    }
}
