﻿using Mall.Common.Enum;
using System;
using VT.FW.DB;

namespace Mall.Model.Entity.BaseSetUp
{
    /// <summary>
    /// 营销中心插件配置实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Marketing_Plug
    {
        /// <summary>
        /// 插件编号
        /// </summary>
        public int PId { get; set; }

        /// <summary>
        /// 插件类型(1-默认，2-营销工具）
        /// </summary>
        public int PlugType { get; set; }

        /// <summary>
        /// 插件名称
        /// </summary>
        public string PlugName { get; set; }

        /// <summary>
        /// 插件子名称
        /// </summary>
        public string PlugSubName { get; set; }

        /// <summary>
        /// 跳转地址
        /// </summary>
        public string PlugUrl { get; set; }

        /// <summary>
        /// 图标地址
        /// </summary>
        public string Icon { get; set; }

        /// <summary>
        /// 样式
        /// </summary>
        public string IconClass { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }
    }
}
