﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Coffee;

namespace Mall.Model.Extend.Coffee
{
    /// <summary>
    /// 咖啡劵消费记录扩展表
    /// </summary>
    public class RB_Member_CoffeeLog_Extend : RB_Member_CoffeeLog
    {
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }

        /// <summary>
        /// 查询类型  1日报表  2月报表  3年报表
        /// </summary>
        public int SelectType { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public string Date { get; set; }

        /// <summary>
        /// 来宾赠送
        /// </summary>
        public int LBFreeNum { get; set; }
        /// <summary>
        /// 来宾购买
        /// </summary>
        public int LBBuyNum { get; set; }
        /// <summary>
        /// 员工赠送
        /// </summary>
        public int EmpFreeNum { get; set; }
        /// <summary>
        /// 员工购买
        /// </summary>
        public int EmpBuyNum { get; set; }
        /// <summary>
        /// 学生赠送
        /// </summary>
        public int StuFreeNum { get; set; }
        /// <summary>
        /// 学生购买
        /// </summary>
        public int StuBuyNum { get; set; }

        /// <summary>
        /// 收款
        /// </summary>
        public decimal Income { get; set; }
        /// <summary>
        /// 核销人
        /// </summary>
        public string EmpName { get; set; }

        /// <summary>
        /// 员工类型  1员工  2学员  3来宾
        /// </summary>
        public int EmpType { get; set; }

        /// <summary>
        /// 微信名称
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 微信头像
        /// </summary>
        public string UserIcon { get; set; }
        /// <summary>
        /// 学生/内部人员名称
        /// </summary>
        public string EmpStuName { get; set; }
    }
}
