﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Common.Enum.Property
{

    /// <summary>
    /// 数据状态
    /// </summary>
    public enum PropertyStatusEnum
    {
        /// <summary>
        /// 空闲
        /// </summary>
        [EnumField("空闲")]
        Leisure = 1,
        /// <summary>
        /// 领用
        /// </summary>
        [EnumField("领用")]
        Receive = 2,
        /// <summary>
        /// 借用
        /// </summary>
        [EnumField("借用")]
        Borrow = 3,
        /// <summary>
        /// 调拨中
        /// </summary>
        [EnumField("调拨中")]
        AllotW = 4,
        /// <summary>
        /// 领用待确认
        /// </summary>
        [EnumField("领用待确认")]
        ReceiveW = 5,
        /// <summary>
        /// 退库待确认
        /// </summary>
        [EnumField("退库待确认")]
        CancellingStocksW = 6,
        /// <summary>
        /// 借用待确认
        /// </summary>
        [EnumField("借用待确认")]
        BorrowW = 7,
        /// <summary>
        /// 归还待确认
        /// </summary>
        [EnumField("归还待确认")]
        GiveBackW = 8,
        /// <summary>
        /// 处置待确认
        /// </summary>
        [EnumField("处置待确认")]
        DisposeW = 9,
        /// <summary>
        /// 已处置
        /// </summary>
        [EnumField("已处置")]
        Dispose = 10
    }
}
