﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Education;
using VT.FW.DB;

namespace Mall.Model.Entity.Coffee
{
    /// <summary>
    /// 教育商品订单实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
	public class RB_Goods_Order
	{
		/// <summary>
		/// OrderId
		/// </summary>
		public int OrderId { get; set; }

		/// <summary>
		/// 订单类型   1咖啡劵   2耗材类   3教师类
		/// </summary>
		public int OrderType { get; set; }

		/// <summary>
		/// 对应电商订单ID
		/// </summary>
		public int MallOrderId { get; set; }

		/// <summary>
		/// 订单号
		/// </summary>
		public string OrderNo { get; set; }

		/// <summary>
		/// 用户类型   1内部人员   2学生   3甲鹤用户
		/// </summary>
		public int UserType { get; set; }

		/// <summary>
		/// 关联帐号
		/// </summary>
		public int AccountId { get; set; }

		/// <summary>
		/// 用户id
		/// </summary>
		public int UserId { get; set; }

		/// <summary>
		/// 用户昵称（甲鹤）
		/// </summary>
		public string UserName { get; set; }

		/// <summary>
		/// 订单来源（平台）  枚举
		/// </summary>
		public int OrderSource { get; set; }

		/// <summary>
		/// 支付方式   枚举
		/// </summary>
		public int PaymentWay { get; set; }

		/// <summary>
		/// 应收金额
		/// </summary>
		public decimal PreferPrice { get; set; }

		/// <summary>
		/// 实收金额
		/// </summary>
		public decimal Income { get; set; }

		/// <summary>
		/// 手续费
		/// </summary>
		public decimal Fee { get; set; }

		/// <summary>
		/// 退款金额
		/// </summary>
		public decimal Refund { get; set; }

		/// <summary>
		/// 下单备注
		/// </summary>
		public string Remark { get; set; }

		/// <summary>
		/// 订单状态  1待付款   2已完成  3已取消
		/// </summary>
		public int OrderStatus { get; set; }

		/// <summary>
		/// 付款时间
		/// </summary>
		public DateTime PaymentTime { get; set; }

		/// <summary>
		/// 取消时间
		/// </summary>
		public DateTime? CancelTime { get; set; }

		/// <summary>
		/// 总成本价格
		/// </summary>
		public decimal CostMoney { get; set; }

		/// <summary>
		/// 删除状态
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 集团ID
		/// </summary>
		public int Group_Id { get; set; }

		/// <summary>
		/// 小程序id
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// CreateDate
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// UpdateDate
		/// </summary>
		public DateTime UpdateDate { get; set; }

		/// <summary>
		/// 总运费成本
		/// </summary>
		public decimal FreightCostMoney { get; set; }
	}
}
