﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 分销商提现表实体h
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Remit
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int? Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 提现方式  枚举
        /// </summary>        
        public DistrbutorWithdrawWayEnum? WithdrawalWay
        {
            get;
            set;
        }
        /// <summary>
        /// 申请金额
        /// </summary>        
        public decimal? AppliedMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 手续费
        /// </summary>        
        public decimal? Fee
        {
            get;
            set;
        }
        /// <summary>
        /// 打款金额
        /// </summary>        
        public decimal? RemitMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 审核状态  1申请中  2同意申请，待打款  3已打款  4拒绝
        /// </summary>        
        public DistributorRemitAuditStatusEnum? AuditStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 审核时间
        /// </summary>        
        public DateTime? AuditDate
        {
            get;
            set;
        }
        /// <summary>
        /// 打款时间
        /// </summary>        
        public DateTime? RemitDate
        {
            get;
            set;
        }
        /// <summary>
        /// 拒绝时间
        /// </summary>
        public DateTime? RejectDate { get; set; }
        /// <summary>
        /// 审核备注
        /// </summary>        
        public string AuditRemark
        {
            get;
            set;
        }
        /// <summary>
        /// 打款备注
        /// </summary>        
        public string RemitRemark
        {
            get;
            set;
        }
        /// <summary>
        /// 拒绝备注
        /// </summary>
        public string RejectRemark { get; set; }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 真实名称
        /// </summary>        
        public string AccountName
        {
            get;
            set;
        }
        /// <summary>
        /// 账户号码
        /// </summary>        
        public string AccountNumber
        {
            get;
            set;
        }
        /// <summary>
        /// 银行名称
        /// </summary>
        public string BankName { get; set; }
        /// <summary>
        /// 提现订单号
        /// </summary>
        public string OrderNum { get; set; }
        /// <summary>
        /// 财务单据id
        /// </summary>
        public int? FinanceId { get; set; }

        /// <summary>
        /// 提现关联订单id
        /// </summary>
        public string ReOrderIds { get; set; }
        /// <summary>
        /// 关联的订单号描述
        /// </summary>
        public string ReOrderNos { get; set; }
        /// <summary>
        /// 关联的vip返佣id
        /// </summary>
        public string ReVipIds { get; set; }
    }
}
