﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace Mall.WindowsService.Helper
{
    public class TimersHelper
    {
        private static int inTimer = 0;

        private static int inTimer1 = 0;
        private static int inTimer2 = 0;
        private static int inTimer3 = 0;
        private static int inTimer4 = 0;
        private static int inTimer5 = 0;
        private static int inTimer6 = 0;
        private static int inTimer7 = 0;
        private static int inTimer8 = 0;
        private static int inTimer9 = 0;

        /// <summary>
        /// 收入单子服务开始执行方法
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void RevenueFinance(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                LogHelper.Write("RevenueFinance=====Start");


                Module.FinanceModule.OrderIncomeFinanceModule();

                LogHelper.Write("RevenueFinance=====End");

                #region 退款制单
                LogHelper.Write("AutoCreateFinanceRefund=====Start");
                Module.FinanceModule.AutoCreateFinanceRefund();
                LogHelper.Write("AutoCreateFinanceRefund=====End");
                #endregion
                #region 分享商VIP过期时间
                LogHelper.Write("DistributorVipModule=====Start");
                Module.FinanceModule.DistributorVipModule();
                LogHelper.Write("DistributorVipModule=====End");
                #endregion

                #region 电商统计

                if (DateTime.Now.Hour == 1)
                {
                    LogHelper.Write("UpdateToDayUserStatistics=====Start");
                    try
                    {
                        new Module.UserStatisticsModule().UpdateToDayUserStatistics("", "");
                    }
                    catch (Exception ex)
                    {
                        LogHelper.Write("UpdateToDayUserStatistics：" + ex.Message);
                    }
                    LogHelper.Write("UpdateToDayUserStatistics=====End");
                }
                #endregion

                Interlocked.Exchange(ref inTimer, 0);
            }
        }

        /// <summary>
        /// 自动取消订单
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoCancelOrder(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer1, 1) == 0)
            {
                LogHelper.Write("AutoCancelOrder=====Start");
                Module.FinanceModule.AutoCancelOrder();
                LogHelper.Write("AutoCancelOrder=====End");
                Interlocked.Exchange(ref inTimer1, 0);
            }
        }

        /// <summary>
        /// 自动收货订单
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoReceivingOrder(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer2, 1) == 0)
            {
                if (DateTime.Now.Hour == 1)
                {
                    LogHelper.Write("AutoReceivingOrder=====Start");
                    Module.FinanceModule.AutoReceivingOrder();
                    LogHelper.Write("AutoReceivingOrder=====End");
                }

                LogHelper.Write("AutoAfterSaleOrderSendCommission=====Start");
                Module.FinanceModule.AutoAfterSaleOrderSendCommission();
                LogHelper.Write("AutoAfterSaleOrderSendCommission=====End");
                Interlocked.Exchange(ref inTimer2, 0);
            }
        }

        /// <summary>
        /// 七天自动取消下线
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void AutoReleaseTheOffline(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer3, 1) == 0)
            {
                if (DateTime.Now.Hour == 1)
                {
                    LogHelper.Write("AutoReleaseTheOffline=====Start");
                    Module.FinanceModule.AutoReleaseTheOffline();
                    LogHelper.Write("AutoReleaseTheOffline=====End");
                }
                Interlocked.Exchange(ref inTimer3, 0);
            }
        }

        /// <summary>
        /// 商品定时上架，下架
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void GoodsShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer4, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("GoodsShelves=====Start" + str);
                    Module.GoodsShelvesModule.ShelvesGoodsModule();
                    Module.GoodsShelvesModule.DownGoodsModule();
                    LogHelper.Write("GoodsShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("GoodsShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer4, 0);
            }
        }



        /// <summary>
        /// 资讯定时上架，下架
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void EducationArticleShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer5, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("EducationArticleShelves=====Start" + str);
                    Module.EducationArticleShelvesModule.ShelvesEducationArticleModule();
                    Module.EducationArticleShelvesModule.DownEducationArticleModule();
                    LogHelper.Write("EducationArticleShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("EducationArticleShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer5, 0);
            }
        }


        /// <summary>
        ///用户储值卡赠送状态更新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void MemberDepositBuyShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer6, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("MemberDepositBuyShelves=====Start" + str);
                    Module.EducationArticleShelvesModule.MemberDepositBuyModule();
                    LogHelper.Write("MemberDepositBuyShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("MemberDepositBuyShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer6, 0);
            }
        }

        /// <summary>
        ///用户储值卡赠送状态更新
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void DepositIncomeFinanceShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer7, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("DepositIncomeFinanceShelves=====Start" + str);

                    Module.FinanceModule.DepositIncomeFinanceModule();
                    LogHelper.Write("DepositIncomeFinanceShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("DepositIncomeFinanceShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer7, 0);
            }
        }

        /// <summary>
        ///相亲每日随机查询信息删除
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void DailyRandomShelves(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer8, 1) == 0)
            {
                try
                {
                    string str = Common.Config.GetConnectionString("DefaultConnection");
                    LogHelper.Write("DailyRandomShelves=====Start" + str);
                    Module.EducationArticleShelvesModule.DailyRandomModule();
                    LogHelper.Write("DailyRandomShelves=====End");
                }
                catch (Exception ex)
                {
                    LogHelper.Write("DailyRandomShelves=====ex" + ex.Message);
                }
                Interlocked.Exchange(ref inTimer8, 0);
            }
        }

        /// <summary>
        /// 赠送咖啡劵
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void EduInitFreeCoffee(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer9, 1) == 0)
            {
                if (DateTime.Now.ToString("dd HH:mm") == "01 00:01" || DateTime.Now.ToString("dd HH:mm") == "01 00:02")
                {
                    //每月1日 凌晨初始化 赠送咖啡劵
                    try
                    {
                        LogHelper.Write("赠送咖啡劵=====S");
                        Module.CoffeeModule.UpdateUserCoffeeFreeNum();
                        LogHelper.Write("赠送咖啡劵=====E");
                    }
                    catch (Exception ex)
                    {
                        LogHelper.Write("EduInitFreeCoffee=====ex" + ex.Message);
                    }
                }
                Interlocked.Exchange(ref inTimer9, 0);
            }
        }

    }
}
