﻿using System.Collections.Generic;
using System.Text;
using Mall.DataAccess;

namespace DapperExtensions.Sql
{
    /// <summary>
    /// Oracle语句配置扩展类
    /// </summary>
    public class OracleDialect : SqlDialectBase
    {
        /// <summary>
        /// 构造函数
        /// </summary>
        public OracleDialect()
        {
            DBType = DataBaseType.Oracle;
        }

        /// <summary>
        /// 参数开始字符
        /// </summary>
        public override char ParameterPrefix
        {
            get { return ':'; }
        }

        /// <summary>
        /// 开始字符
        /// </summary>
        public override char OpenQuote
        {
            get { return '"'; }
        }

        /// <summary>
        /// 结束字符
        /// </summary>
        public override char CloseQuote
        {
            get { return '"'; }
        }

        /// <summary>
        /// 获取自增Sql
        /// </summary>
        /// <param name="tableName">表名</param>
        /// <returns></returns>
        public override string GetIdentitySql(string tableName)
        {
            return "SELECT CONVERT(LAST_INSERT_ID(), SIGNED INTEGER) AS ID";
        }

        /// <summary>
        /// 是否支持多项结构
        /// </summary>
        public override bool SupportsMultipleStatements
        {
            get { return false; }
        }

        /// <summary>
        /// 获取分页Sql
        /// </summary>
        /// <param name="sql">SQL命令</param>
        /// <param name="page">页码</param>
        /// <param name="resultsPerPage">页大小</param>
        /// <param name="parameters">参数</param>
        /// <returns></returns>
        public override string GetPagingSql(string sql, int page, int resultsPerPage, IDictionary<string, object> parameters)
        {
            if (page <= 0)
            {
                page = 1;
            }
            int startValue = (page - 1) * resultsPerPage;
            return GetSetSql(sql, startValue, resultsPerPage, parameters);
        }

        /// <summary>
        /// 获取分页SQL
        /// </summary>
        /// <param name="sql">SQL命令</param>
        /// <param name="firstResult">开始值</param>
        /// <param name="maxResults">最大值/结束值</param>
        /// <param name="parameters">参数</param>
        /// <returns></returns>
        public override string GetSetSql(string sql, int firstResult, int maxResults, IDictionary<string, object> parameters)
        {
            var toSkip = firstResult;// page * resultsPerPage;
            var topLimit = firstResult + maxResults;

            var sb = new StringBuilder();
            sb.AppendLine("SELECT * FROM (");
            sb.AppendLine("SELECT \"_ss_dapper_1_\".*, ROWNUM RNUM FROM (");
            sb.Append(sql);
            sb.AppendLine(") \"_ss_dapper_1_\"");
            sb.AppendLine("WHERE ROWNUM <= :topLimit) \"_ss_dapper_2_\" ");
            sb.AppendLine("WHERE \"_ss_dapper_2_\".RNUM > :toSkip");
            parameters.Add(":topLimit", topLimit);
            parameters.Add(":toSkip", toSkip);
            return sb.ToString();
        }
    }
}