﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联分类仓储层
    /// </summary>
    public class RB_Goods_CategoryRepository : RepositoryBase<RB_Goods_Category>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Category_Extend> GetList(RB_Goods_Category_Extend dmodel)
        {
            string where = $" 1=1 and gc.{nameof(RB_Goods_Category.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and gc.{nameof(RB_Goods_Category.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and gc.{nameof(RB_Goods_Category.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and gc.{nameof(RB_Goods_Category.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and gc.{nameof(RB_Goods_Category.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and gc.{nameof(RB_Goods_Category.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"select gc.*,pc.Name as CategoryName,pc.IsForeignShare from RB_Goods_Category gc
inner join rb_product_category pc on gc.CategoryId=pc.Id
where {where} order by gc.Id desc";
            return Get<RB_Goods_Category_Extend>(sql).ToList();
        }
    }
}
