﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 门店表仓储层
    /// </summary>
    public class RB_StoresRepository : RepositoryBase<RB_Stores>
    {
        /// <summary>
        /// 门店分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Stores_Extend> GetStoresPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Stores_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Stores WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.Id), query.Id);
            }
            if (query.Name!=null && !string.IsNullOrEmpty(query.Name.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Stores_Extend.Name), query.Name.Trim());
            }
            builder.Append(" ORDER BY Id DESC ");
            return GetPage<RB_Stores_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 门店分类列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stores_Extend> GetStoresListRepository(RB_Stores_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Stores WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Stores_Extend.Id), query.Id);
            }
            if (query.Name != null && !string.IsNullOrEmpty(query.Name.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Stores_Extend.Name), query.Name.Trim());
            }
            builder.Append(" ORDER BY Id DESC ");
            return Get<RB_Stores_Extend>(builder.ToString()).ToList();
        }
    }
}