﻿using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    public class RB_MallBaseRepository : RepositoryBase<RB_MallBase>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_MallBase); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string MinTableName { get { return nameof(RB_MiniProgram); } }

        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MallBase_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1 ");
            if (query != null)
            {
                // where += $@" and ={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_MallBase_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_MallBase_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            return GetPage<RB_MallBase_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MallBase_Extend> GetListRepository(RB_MallBase_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.MallName FROM {TableName} as a LEFT join {MinTableName} as b on a.MallBaseId=b.MallBaseId WHERE 1=1  ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_MallBase_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_MallBase_Extend.MallBaseId)}={query.MallBaseId}");
                }
            }
            return Get<RB_MallBase_Extend>( builder.ToString()).ToList();
        }

    }
}
