﻿using DapperExtensions;
using DapperExtensions.Lambda;
using Mall.DataAccess.Utils;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Repository
{
    /// <summary>
    /// Lambda帮助类
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface ILambdaHelper<T> : IDataRepository<T> where T : class
    {

        /// <summary>
        /// LambdaUpdate
        /// </summary>
        /// <param name="transaction">事务对象</param>
        /// <param name="commandTimeout">超时时间</param>
        /// <returns></returns>
        LambdaUpdateHelper<T> LambdaUpdate(IDbTransaction transaction = null, int? commandTimeout = null);

        /// <summary>
        /// LambdaUpdate
        /// </summary>
        /// <typeparam name="TEntity">约束</typeparam>
        /// <param name="transaction">事务对象</param>
        /// <param name="commandTimeout">超时时间</param>
        /// <returns></returns>
        LambdaUpdateHelper<TEntity> LambdaUpdate<TEntity>(IDbTransaction transaction = null, int? commandTimeout = null) where TEntity : class;

        /// <summary>
        /// LambdaQuery
        /// </summary>
        /// <param name="transaction">事务对象</param>
        /// <param name="commandTimeout">超时时间</param>
        /// <returns></returns>
        LambdaQueryHelper<T> LambdaQuery(IDbTransaction transaction = null, int? commandTimeout = null);


        /// <summary>
        /// LambdaQuery
        /// </summary>
        /// <typeparam name="TEntity">约束</typeparam>
        /// <param name="transaction">事务对象</param>
        /// <param name="commandTimeout">超时时间</param>
        /// <returns></returns>
        LambdaQueryHelper<TEntity> LambdaQuery<TEntity>(IDbTransaction transaction = null, int? commandTimeout = null) where TEntity : class;

    }
}
