﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 和平分销返佣比例仓储层
    /// </summary>
    public class RB_Distributor_HPGradeRatioRepository : RepositoryBase<RB_Distributor_HPGradeRatio>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPGradeRatio_Extend> GetList(RB_Distributor_HPGradeRatio_Extend dmodel)
        {
            string where = $@" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_HPGradeRatio.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_HPGradeRatio.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.CommissionId > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_HPGradeRatio.CommissionId)}={dmodel.CommissionId}";
            }
            if (!string.IsNullOrEmpty(dmodel.CommissionIds)) {
                where += $@" and r.{nameof(RB_Distributor_HPGradeRatio.CommissionId)} in({dmodel.CommissionIds})";
            }
            if (dmodel.IsGuest == 1) {
                where += $@" and g.{nameof(RB_Distributor_HPGradeInfo.IsGuest)}=1";
            }

            string sql = $@"select r.*,g.Grade,g.GradeName from RB_Distributor_HPGradeRatio r
inner join RB_Distributor_HPGradeInfo g on r.GradeId = g.Id
where {where} order by r.Id desc";
            return Get<RB_Distributor_HPGradeRatio_Extend>(sql).ToList();
        }
    }
}
