﻿using Mall.Common.Enum;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.API
{
    /// <summary>
    /// API请求参数
    /// </summary>
    public class RequestParm
    {
        /// <summary>
        /// 商户Id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 用户ID
        /// </summary>
        public string uid { get; set; }
        /// <summary>
        /// 请求消息
        /// </summary>
        public object msg { get; set; }

        /// <summary>
        /// 请求时间戳
        /// </summary>
        public string timestamp { get; set; }
        /// <summary>
        /// 签名
        /// </summary>
        public string sign { get; set; }

        /// <summary>
        /// token信息
        /// </summary>
        public string token { get; set; }
        /// <summary>
        /// 客户端版本
        /// </summary>
        public string version { get; set; }
        /// <summary>
        /// 语言  0中文   1繁体  2日文（未处理）
        /// </summary>
        public int languageId { get; set; }

        /// <summary>
        /// 语种类型
        /// </summary>
        public LanguageTypeEnum languageType { get; set; }

        /// <summary>
        /// 员工编号【员工登录时使用】
        /// </summary>
        public int EmpId { get; set; }

        /// <summary>
        /// 小程序Id
        /// </summary>
        public string MiniAppId { get; set; }

        /// <summary>
        /// 用户OpenId
        /// </summary>
        public string OpenId { get; set; }

        /// <summary>
        /// 小程序登录用户编号
        /// </summary>
        public int UserId { get; set; }
    }
}
