﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Product;
using Mall.AOP;
using Mall.Model.Extend.GuideCar;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class GuideCarController : BaseController
    {

        private readonly GuideCarModule guideCarModule = new GuideCarModule();

        #region 基础配置
        /// <summary>
        /// 获取司导专区基础配置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetGuideCarInfo() {
            var req = RequestParm;

            var model = guideCarModule.GetGuideCarInfo(req.TenantId, req.MallBaseId);
            return ApiResult.Success("", model);
        }

        /// <summary>
        /// 保存司导专区配置
        /// </summary>
        /// <returns></returns>
        public ApiResult SetGuideCarInfo() {
            var req = RequestParm;
            RB_GuideCar_Base_Extend demodel = JsonConvert.DeserializeObject<RB_GuideCar_Base_Extend>(req.msg.ToString());

            if (string.IsNullOrEmpty(demodel.PagePath)) {
                return ApiResult.ParamIsNull("请输入详情页面链接地址");
            }

            demodel.OrderStateJson = "";
            if (demodel.OrderStateList != null && demodel.OrderStateList.Any()) {
                demodel.OrderStateJson = JsonConvert.SerializeObject(demodel.OrderStateList);
            }
            demodel.TenantId = req.TenantId;
            demodel.MallBaseId = req.MallBaseId;
            demodel.UpdateBy = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = guideCarModule.SetGuideCarInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else {
                return ApiResult.Failed();
            }
        }


        #endregion



        #region 站点配置

        #endregion
    }
}