﻿using System;
using VT.FW.DB;
using Mall.Common.Plugin;

namespace Mall.Model.Entity.Property
{

    /// <summary>
    /// 耗材有效期实体
    /// </summary> 
    [Serializable]
    [DB(ConnectionName = "PropertyConnection")]
    public class RB_Supplies_StockInValidity
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 入库单id
        /// </summary>
        public int StockinId { get; set; }

        /// <summary>
        /// 入库单明细id
        /// </summary>
        public int StockinDetailId { get; set; }

        /// <summary>
        /// 有效日期
        /// </summary>
        public DateTime ExpirationDate { get; set; }

        /// <summary>
        /// 是否出库  1是  2否
        /// </summary>
        public int IsOut { get; set; }

        /// <summary>
        /// 出库单id
        /// </summary>
        public int StockoutId { get; set; }

        /// <summary>
        /// 状态 0正常  1删除
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 集团
        /// </summary>
        public int RB_Group_Id { get; set; }

        /// <summary>
        /// CreateBy
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// CreateDate
        /// </summary>
        public DateTime CreateDate { get; set; }

    }
}