﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联区域仓储层
    /// </summary>
    public class RB_Goods_AreaRepository : BaseRepository<RB_Goods_Area>
    {

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Area_Extend> GetList(RB_Goods_Area_Extend dmodel)
        {
            string where = $" 1=1 and ga.{nameof(RB_Goods_Area.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and ga.{nameof(RB_Goods_Area.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and ga.{nameof(RB_Goods_Area.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and ga.{nameof(RB_Goods_Area.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and ga.{nameof(RB_Goods_Area.GoodsId)}={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and ga.{nameof(RB_Goods_Area.GoodsId)} in({dmodel.GoodsIds})";
            }
            
            string sql = $@"select ga.*,d.Name as AreaName from RB_Goods_Area ga
inner join rb_destination d on ga.AreaId=d.ID
where {where} order by ga.Id desc";
            return Get<RB_Goods_Area_Extend>(sql).ToList();
        }
    }
}
