﻿using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Reserve
{
    public class RB_Reserve_ServicePersonalProductRepository:BaseRepository<RB_Reserve_ServicePersonalProduct>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Reserve_ServicePersonalProduct); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string PCategoryTableName { get { return nameof(Model.Entity.Product.RB_Product_Category); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string GoodsTableName { get { return nameof(Model.Entity.Product.RB_Goods); } }

        /// <summary>
        /// 服务人员对应的商品/分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonalProduct> GetServicePersonalProductList(RB_Reserve_ServicePersonalProduct query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Reserve_ServicePersonalProduct.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_ServicePersonalProduct.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_ServicePersonalProduct.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_ServicePersonalProduct.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ServiceId > 0)
                {
                    builder.Append($" AND {nameof(RB_Reserve_ServicePersonalProduct.ServiceId)}={query.ServiceId}");
                }
            }
            return Get<RB_Reserve_ServicePersonalProduct>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 服务人员对应的商品/分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonalProduct_Extend> GetListByServicePersonalProductIds(RB_Reserve_ServicePersonal_Extend query, string ServiceIds, bool IsSelectDel = false)
        {
            StringBuilder builder = new StringBuilder();

            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonalProduct.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonalProduct.MallBaseId)}={query.MallBaseId}");
                }
            }
            if (!string.IsNullOrWhiteSpace(ServiceIds))
            {
                builder.Append($" AND a.{nameof(RB_Reserve_ServicePersonalProduct.ServiceId)} in ({ServiceIds})");
            }
            string sql = "";
            if (IsSelectDel)
            {
                sql = $"SELECT a.* from {TableName} as a  WHERE 1=1 ";
            }
            else
            {
                sql = $"SELECT a.* from {TableName} as a  WHERE a.{nameof(RB_Reserve_ServicePersonalProduct.Status)}=0 {builder.ToString()}  ";
            }
            if (query.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Category)
            {
                sql = $" SELECT a.*,b.`Name` as Relevance from {TableName} as a LEFT JOIN {PCategoryTableName} as b on a.ProductId=b.Id WHERE a.{nameof(RB_Reserve_ServicePersonalProduct.Status)}=0 {builder.ToString()} ";
            }
            else if (query.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Product)
            {
                sql = $" SELECT a.*,b.`Name` as Relevance from {TableName} as a LEFT JOIN {GoodsTableName} as b on a.ProductId=b.Id WHERE a.{nameof(RB_Reserve_ServicePersonalProduct.Status)}=0 {builder.ToString()} ";
            }
            return Get<RB_Reserve_ServicePersonalProduct_Extend>(sql).ToList();
        }
    }
}
