﻿using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Module.TradePavilion;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class CustomFormController : BaseController
    {
        /// <summary>
        /// 自定义表单处理类对象
        /// </summary>
        private readonly CustomFormModule customFormModule = new CustomFormModule();

        /// <summary>
        /// 获取自定义表单分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCustomFormPage()
        {
            ResultPageModel pageModel = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Custom_Form_Extend()
            {
                FormName = parms.GetStringValue("FormName"),
                FormType = (Common.Enum.TradePavilion.CustomFormTypeEnum)parms.GetInt("FormType")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = customFormModule.GetCustomFormPageModule(pageModel.pageIndex, pageModel.pageSize, out long rowsCount, query);
            pageModel.count = Convert.ToInt32(rowsCount);
            pageModel.pageData = list.Select(qitem => new
            {
                qitem.Id,
                qitem.FormType,
                qitem.FormTypeStr,
                qitem.FormName,
                qitem.FormDataList,
                CreateDate = Common.ConvertHelper.FormatTime(qitem.CreateDate),
            });
            return ApiResult.Success(data: pageModel);
        }

        /// <summary>
        /// 获取自定义表单列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCustomFormList()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var query = new RB_Custom_Form_Extend()
            {
                FormName = parms.GetStringValue("FormName"),
                FormType = (Common.Enum.TradePavilion.CustomFormTypeEnum)parms.GetInt("FormType")
            };
            query.MallBaseId = RequestParm.MallBaseId;
            query.TenantId = RequestParm.TenantId;
            var list = customFormModule.GetCustomFormListModule(  query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增修改自定义表单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetCustomForm()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var model = new RB_Custom_Form_Extend()
            {
                Id=parms.GetInt("Id"),
                FormName = parms.GetStringValue("FormName"),
                FormType = (Common.Enum.TradePavilion.CustomFormTypeEnum)parms.GetInt("FormType")
            };
            var formData = parms.GetStringValue("FormData");
            List<FormDataItem> dataList = customFormModule.AnalyzeFormComponent(formData);
            if (dataList != null && dataList.Count > 0)
            {
                model.FormData = Common.Plugin.JsonHelper.Serialize(dataList);
            }
            else
            {
                model.FormData = "";
            }
            model.MallBaseId = RequestParm.MallBaseId;
            model.TenantId = RequestParm.TenantId;
            model.CreateBy = base.UserInfo.TenantId;
            model.UpdateBy = base.UserInfo.TenantId;
            model.CreateDate = DateTime.Now;
            model.UpdateDate = DateTime.Now;
            model.Status = Common.Enum.DateStateEnum.Normal;
            if (customFormModule.CheckExistsCustomFormModule(model))
            {
                return ApiResult.Failed(message: "已存在此类型的表单!");
            };
            var flag = customFormModule.SetCustomFormModule(model);
            return flag ? ApiResult.Success(data:model) : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号编号获取自定义表单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCustomForm()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id");
            var extModel = customFormModule.GetCustomFormModule(Id);
            return ApiResult.Success(data: extModel);
        }

        /// <summary>
        /// 根据编号删除自定义表单
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult RemoveCustomeForm()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            var Id = parms.GetInt("Id");
            var flag = customFormModule.RemoveCustomFormModule(Id);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 获取自定义表单类型
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCustomType()
        {
            var list = EnumHelper.EnumToList(typeof(Common.Enum.TradePavilion.CustomFormTypeEnum));
            return ApiResult.Success(data:list);
        }
    }
}
