﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 员工表仓储层
    /// </summary>
    public class RB_EmployeeRepository : BaseRepository<RB_Employee>
    {
        /// <summary>
        /// 员工分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmployeePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Employee_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Employee WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Employee_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Employee_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.EmpId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Employee_Extend.EmpId), query.EmpId);
            }
            if (query.EmpName != null && !string.IsNullOrEmpty(query.EmpName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Employee_Extend.EmpName), query.EmpName.Trim());
            }

            return GetPage<RB_Employee_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取员工列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Employee_Extend> GetEmployeeListRepository(RB_Employee_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Employee WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Employee_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Employee_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.EmpId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Employee_Extend.EmpId), query.EmpId);
            }
            if (query.EmpName != null && !string.IsNullOrEmpty(query.EmpName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Employee_Extend.EmpName), query.EmpName.Trim());
            }
            if (!string.IsNullOrEmpty(query.EmployeeIds)) {
                builder.AppendFormat(" AND {0} in({1}) ", nameof(RB_Employee_Extend.EmpId), query.EmployeeIds);
            }
            return Get<RB_Employee_Extend>(builder.ToString()).ToList();
        }
    }
}