﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商户表仓储层
    /// </summary>
    public class RB_TenantRepository : BaseRepository<RB_Tenant>
    {
        /// <summary>
        /// 根据查询条件获取商户列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetListRepository(RB_Tenant_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Tenant WHERE 1=1 ");
            if (query != null)
            {
                if (query.Account != null && !string.IsNullOrEmpty(query.Account.Trim()))
                {
                    builder.AppendFormat(" AND Account='{0}' ", query.Account.Trim());
                }
            }
            return Get<RB_Tenant_Extend>(builder.ToString()).ToList();
        }



        /// <summary>
        /// 根据查询条件获取商户列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetTenantListByIds(string TenantIds)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Tenant WHERE 1=1 ");
            if (!string.IsNullOrWhiteSpace(TenantIds))
            {
                builder.AppendFormat(" AND TenantId in ({0}) ", TenantIds);
            }
            return Get<RB_Tenant_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据小程序获取商户信息
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Tenant_Extend GetTenantByMallRepository(RB_Tenant_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@"
SELECT A.TenantId,B.EmpAccount AS Account,A.Name,A.MobilePhone,A.WeChatNum,A.IsEffective,A.AccountValidate,A.CreateMiniPrograme
        ,A.AccountStatus,B.EmpPwd AS Password,B.EmpId
FROM RB_Tenant AS A  LEFT JOIN rb_employee AS B ON A.TenantId=B.TenantId
WHERE 1=1 ");
            if (query != null)
            {
                if (query.Account != null && !string.IsNullOrEmpty(query.Account.Trim()))
                {
                    builder.AppendFormat(" AND B.EmpAccount='{0}' ", query.Account.Trim());
                }
            }
            return Get<RB_Tenant_Extend>(builder.ToString()).FirstOrDefault();
        }

        /// <summary>
        /// 获取商户分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Tenant_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Tenant_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Tenant WHERE 1=1 ");
            return GetPage<RB_Tenant_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
    }
}
