﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Common.Enum.MiAi;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 用户统计表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_User_Statistics_Extend : RB_User_Statistics
    {
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public string DateStr { get; set; }

        /// <summary>
        /// 月份
        /// </summary>
        public string DateMonth { get { return this.Date.ToString("yyyy-MM"); } }

        /// <summary>
        /// 获取其年份
        /// </summary>
        public int DateYear { get { return this.Date.Year; } }
    }

    /// <summary>
    /// 月度统计
    /// </summary>
    public class User_Statistics_Query
    {
        /// <summary>
        /// 日期(yyyy-MM)
        /// </summary>
        public string Date { get; set; }

        /// <summary>
        /// 付款人数
        /// </summary>
        public int PeopleNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int OrderNum { get; set; }

        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal PayMoney { get; set; }

        /// <summary>
        /// 购买数量
        /// </summary>
        public int BuyNum { get; set; }

        /// <summary>
        /// 累计付款人数
        /// </summary>
        public int TotalPayPeople { get; set; }


        /// <summary>
        /// 付款人数
        /// </summary>
        public decimal MAvgPeopleNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public decimal MAvgOrderNum { get; set; }

        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal MAvgPayMoney { get; set; }

        /// <summary>
        /// 购买数量
        /// </summary>
        public decimal MAvgBuyNum { get; set; }


        /// <summary>
        /// 平均每人购买单数
        /// </summary>
        public decimal PAvgOrderNum { get; set; }

        /// <summary>
        /// 平均每人购买件数
        /// </summary>
        public decimal PAvgBuyNum { get; set; }

        /// <summary>
        /// 平均每单单价
        /// </summary>
        public decimal PAvgUnitPrice { get; set; }

        /// <summary>
        /// 平均每人购买单价
        /// </summary>
        public decimal PAvgBuyPrice { get; set; }

        /// <summary>
        /// 平均会员数量
        /// </summary>
        public decimal PAvgMemberNum { get; set; }

        /// <summary>
        /// 平均付款累计人数
        /// </summary>
        public decimal PAvgPaymentNum { get; set; }

        /// <summary>
        /// 平均會員下訂單轉換率
        /// </summary>
        public decimal PAvgMOrderRate { get; set; }

        /// <summary>
        /// 平均复购人数
        /// </summary>
        public decimal PAvgReBuyNum { get; set; }

        /// <summary>
        /// 平均复购率
        /// </summary>
        public decimal PAvgReBuyRate { get; set; }

        /// <summary>
        /// 平均新人下单
        /// </summary>
        public decimal PAvgNewPeopleNum { get; set; }

        /// <summary>
        /// 平均利润率
        /// </summary>
        public decimal PAvgProfitRate { get; set; }

        /// <summary>
        /// 今日普象新增
        /// </summary>
        public int PXNum { get; set; }

        /// <summary>
        /// 今日VIP新增
        /// </summary>
        public int VipNum { get; set; }

        /// <summary>
        /// 今日银象新增
        /// </summary>
        public int YXNum { get; set; }

        /// <summary>
        /// 今日金象新增
        /// </summary>
        public int JXNum { get; set; }

        /// <summary>
        /// 总会员数量
        /// </summary>
        public int TotalMNum { get; set; }

        /// <summary>
        /// 利润
        /// </summary>
        public decimal Profit { get; set; }

    }

    /// <summary>
    /// 全部小数的
    /// </summary>
    public class User_Statistics_Query_V2
    {
        /// <summary>
        /// 日期(yyyy-MM)
        /// </summary>
        public string Date { get; set; }

        /// <summary>
        /// 付款人数
        /// </summary>
        public decimal PeopleNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public decimal OrderNum { get; set; }

        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal PayMoney { get; set; }

        /// <summary>
        /// 购买数量
        /// </summary>
        public decimal BuyNum { get; set; }

        /// <summary>
        /// 累计付款人数
        /// </summary>
        public decimal TotalPayPeople { get; set; }


        /// <summary>
        /// 付款人数
        /// </summary>
        public decimal MAvgPeopleNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public decimal MAvgOrderNum { get; set; }

        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal MAvgPayMoney { get; set; }

        /// <summary>
        /// 购买数量
        /// </summary>
        public decimal MAvgBuyNum { get; set; }


        /// <summary>
        /// 平均每人购买单数
        /// </summary>
        public decimal PAvgOrderNum { get; set; }

        /// <summary>
        /// 平均每人购买件数
        /// </summary>
        public decimal PAvgBuyNum { get; set; }

        /// <summary>
        /// 平均每单单价
        /// </summary>
        public decimal PAvgUnitPrice { get; set; }

        /// <summary>
        /// 平均每人购买单价
        /// </summary>
        public decimal PAvgBuyPrice { get; set; }

        /// <summary>
        /// 平均会员数量
        /// </summary>
        public decimal PAvgMemberNum { get; set; }

        /// <summary>
        /// 平均付款累计人数
        /// </summary>
        public decimal PAvgPaymentNum { get; set; }

        /// <summary>
        /// 平均會員下訂單轉換率
        /// </summary>
        public decimal PAvgMOrderRate { get; set; }

        /// <summary>
        /// 平均复购人数
        /// </summary>
        public decimal PAvgReBuyNum { get; set; }

        /// <summary>
        /// 平均复购率
        /// </summary>
        public decimal PAvgReBuyRate { get; set; }

        /// <summary>
        /// 平均新人下单
        /// </summary>
        public decimal PAvgNewPeopleNum { get; set; }

        /// <summary>
        /// 平均利润率
        /// </summary>
        public decimal PAvgProfitRate { get; set; }

        /// <summary>
        /// 今日普象新增
        /// </summary>
        public decimal PXNum { get; set; }

        /// <summary>
        /// 今日VIP新增
        /// </summary>
        public decimal VipNum { get; set; }

        /// <summary>
        /// 今日银象新增
        /// </summary>
        public decimal YXNum { get; set; }

        /// <summary>
        /// 今日金象新增
        /// </summary>
        public decimal JXNum { get; set; }

        /// <summary>
        /// 总会员数量
        /// </summary>
        public decimal TotalMNum { get; set; }

        /// <summary>
        /// 利润
        /// </summary>
        public decimal Profit { get; set; }

    }

    /// <summary>
    /// 月度概率
    /// </summary>
    public class User_Statistics_Rate_Query
    {
        /// <summary>
        /// 日期(yyyy-MM)
        /// </summary>
        public string Date { get; set; }

        /// <summary>
        /// 付款人数
        /// </summary>
        public decimal MAvgPeopleNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public decimal MAvgOrderNum { get; set; }

        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal MAvgPayMoney { get; set; }

        /// <summary>
        /// 购买数量
        /// </summary>
        public decimal MAvgBuyNum { get; set; }


        /// <summary>
        /// 平均每人购买单数
        /// </summary>
        public decimal PAvgOrderNum { get; set; }

        /// <summary>
        /// 平均每人购买件数
        /// </summary>
        public decimal PAvgBuyNum { get; set; }

        /// <summary>
        /// 平均每单单价
        /// </summary>
        public decimal PAvgUnitPrice { get; set; }

        /// <summary>
        /// 平均每人购买单价
        /// </summary>
        public decimal PAvgBuyPrice { get; set; }

        /// <summary>
        /// 平均會員下訂單轉換率
        /// </summary>
        public decimal PAvgMOrderRate { get; set; }

        /// <summary>
        /// 平均利润率
        /// </summary>
        public decimal PAvgProfitRate { get; set; }

        /// <summary>
        /// 今日普象新增
        /// </summary>
        public decimal PAvgPXNum { get; set; }

        /// <summary>
        /// 今日VIP新增
        /// </summary>
        public decimal PAvgVipNum { get; set; }

        /// <summary>
        /// 今日银象新增
        /// </summary>
        public decimal PAvgYXNum { get; set; }

        /// <summary>
        /// 今日金象新增
        /// </summary>
        public decimal PAvgJXNum { get; set; }

        /// <summary>
        /// 总会员数量
        /// </summary>
        public decimal PAvgTotalMNum { get; set; }

        /// <summary>
        /// 利润
        /// </summary>
        public decimal PAvgProfit { get; set; }

    }
}
