﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.ServiceProcess;
using System.Text;
using Mall.WindowsService.Helper;
namespace Mall.WindowsService
{
    partial class WindowsService : ServiceBase
    {
        System.Timers.Timer timer1;  //计时器
        private System.Timers.Timer timer2;  //订单取消计时器
        private System.Timers.Timer timer3;  //订单自动收货计时器
        private System.Timers.Timer timer4;  //七天自动取消下线计时器

        public WindowsService()
        {
            InitializeComponent();
        }

        protected override void OnStart(string[] args)
        {
            // TODO: 在此处添加代码以启动服务。
            Helper.LogHelper.Write("主服务开始运行......");
            TimersHelper helper = new TimersHelper();
            timer1 = new System.Timers.Timer();
            timer1.Interval = 1000 * (60 * 30); //60分钟
            timer1.Elapsed += new System.Timers.ElapsedEventHandler(helper.RevenueFinance);
            timer1.Enabled = true;

            #region 订单取消定时器

            timer2 = new System.Timers.Timer
            {
                Interval = 1000 * (60 * 10) //10分钟处理一次
            };
            timer2.Elapsed += new System.Timers.ElapsedEventHandler(helper.AutoCancelOrder);
            timer2.Enabled = true;

            #endregion

            #region 订单自动完成定时器

            timer3 = new System.Timers.Timer();
            timer3 = new System.Timers.Timer
            {
                Interval = 1000 * (60 * 60) //60分钟调用一次
            };
            timer3.Elapsed += new System.Timers.ElapsedEventHandler(helper.AutoReceivingOrder);
            timer3.Enabled = true;

            #endregion

            #region 七天自动取消下线

            timer4 = new System.Timers.Timer();
            timer4 = new System.Timers.Timer
            {
                Interval = 1000 * (60 * 60) //60分钟调用一次
            };
            timer4.Elapsed += new System.Timers.ElapsedEventHandler(helper.AutoReleaseTheOffline);
            timer4.Enabled = true;

            #endregion
        }

        protected override void OnStop()
        {
            // TODO: 在此处添加代码以执行停止服务所需的关闭操作。
            Helper.LogHelper.Write("主服务停止运行......");
            this.timer1.Enabled = false;
            this.timer2.Enabled = false;
            this.timer3.Enabled = false;
            this.timer4.Enabled = false;
        }
    }
}
