﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品推荐设置仓储层
    /// </summary>
    public class RB_Product_RecommendRepository : RepositoryBase<RB_Product_Recommend>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Product_Recommend_Extend> GetList(RB_Product_Recommend_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Product_Recommend_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Product_Recommend_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Product_Recommend_Extend.Id)}={dmodel.Id}";
            }

            string sql = $@"select * from RB_Product_Recommend where {where} order by Id desc";
            return Get<RB_Product_Recommend_Extend>(sql).ToList();
        }
    }
}
