﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 小程序自定义页面仓储层
    /// </summary>
    public class RB_Miniprogram_Page_TemplRepository : RepositoryBase<RB_Miniprogram_Page_Templ>
    {
        /// <summary>
        /// 小程序自定义页面分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Page_Templ_Extend> GetMiniprogramPageTemplPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_Page_Templ_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Miniprogram_Page_Templ WHERE Status=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PageName != null && !string.IsNullOrWhiteSpace(query.PageName.Trim()))
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.PageName)} like '%{query.PageName.Trim()}%'");
                }
            }
            return GetPage<RB_Miniprogram_Page_Templ_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 设置不为首页
        /// </summary>
        /// <returns></returns>
        public bool UpdateIsHomeRepository()
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" UPDATE RB_Miniprogram_Page_Templ SET IsHome=0 ");
            return base.Execute(builder.ToString())>0;
        }


        /// <summary>
        /// 小程序自定义页面列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Page_Templ_Extend> GetMiniprogramPageTemplListRepository(RB_Miniprogram_Page_Templ_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Miniprogram_Page_Templ WHERE Status=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PageName != null && !string.IsNullOrWhiteSpace(query.PageName.Trim()))
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.PageName)} like '%{query.PageName.Trim()}%'");
                }
            }
            return Get<RB_Miniprogram_Page_Templ_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 小程序自定义页面实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <param name="isGetHome">是否查询首页页面</param>
        /// <returns></returns>
        public RB_Miniprogram_Page_Templ_Extend GetMiniprogramPageTemplRepository(RB_Miniprogram_Page_Templ_Extend query,bool isGetHome=false)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Miniprogram_Page_Templ WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PageName != null && !string.IsNullOrWhiteSpace(query.PageName.Trim()))
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.PageName)} like '%{query.PageName.Trim()}%'");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.Id)}={query.Id}");
                }
                if (isGetHome)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Extend.IsHome)}=1 ");
                }
            }
            return Get<RB_Miniprogram_Page_Templ_Extend>(builder.ToString()).FirstOrDefault();
        }
    }
}
