﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;

namespace Mall.Model.Extend.Miai
{
    /// <summary>
    /// 活动表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miai_Activity_Extend : RB_Miai_Activity
    {
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }

        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }

        /// <summary>
        /// 性别  1男  2女
        /// </summary>
        public int Sex { get; set; }

        /// <summary>
        /// 图片列表
        /// </summary>
        public List<string> ImageList { get; set; }

        /// <summary>
        /// 回复数量
        /// </summary>
        public int ReplyNum { get; set; }

        /// <summary>
        /// 报名数量
        /// </summary>
        public int EnrollNum { get; set; }

        /// <summary>
        /// 只看可报名   1是
        /// </summary>
        public int IsSelectEnroll { get; set; }

        /// <summary>
        /// 排序  0默认最新  1报名人数倒序  2回复数量倒序
        /// </summary>
        public int OrderBy { get; set; }

        /// <summary>
        /// 活动ids
        /// </summary>
        public string ActivityIds { get; set; }

        /// <summary>
        /// 版块名称
        /// </summary>
        public string ForumName { get; set; }
        /// <summary>
        /// 版块图标
        /// </summary>
        public string ForumIcon { get; set; }
    }
}
