﻿using System;
using System.Collections.Generic;
using System.Linq;
using Mall.Common.Plugin;
using Mall.Model.Extend.MarketingCenter;
using Mall.Repository.MarketingCenter;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using VT.FW.DB;

namespace Mall.Module.MarketingCenter
{
    /// <summary>
    /// 小程序模板处理类
    /// </summary>
    public class MiniprogramTemplateModule
    {
        /// <summary>
        /// 小程序模板仓储层对象
        /// </summary>
        private readonly RB_Miniprogram_TemplateRepository miniprogram_TemplateRepository = new RB_Miniprogram_TemplateRepository();
        private readonly Repository.Miai.RB_MiAi_BaseInfoRepository miai_BaseInfoRepository = new Repository.Miai.RB_MiAi_BaseInfoRepository();
        private readonly Repository.Miai.RB_MiAi_BaseInfoQueryRepository miai_BaseInfoQueryRepository = new Repository.Miai.RB_MiAi_BaseInfoQueryRepository();
        /// <summary>
        /// 小程序模板分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplatePageListModule(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_Template_Extend query)
        {
            return miniprogram_TemplateRepository.GetMiniprogramTemplatePageListRepository(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 小程序模板列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <param name="IsAnalyzePlus">是否解析插件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplateListModule(RB_Miniprogram_Template_Extend query, int TenantId = 0, int MallBaseId = 0, int UserId = 0, bool IsAnalyzePlus = false)
        {
            var list = miniprogram_TemplateRepository.GetMiniprogramTemplateListRepository(query);
            if (IsAnalyzePlus)
            {
                foreach (var item in list)
                {
                    if (item.TemplateData != null && !string.IsNullOrEmpty(item.TemplateData))
                    {
                        item.ComponentDataList = JsonHelper.DeserializeObject<List<ComponentItem>>(Mall.Common.ConvertHelper.JsonReplaceSign(item.TemplateData));
                        if (item.ComponentDataList != null && item.ComponentDataList.Count > 0)
                        {
                            foreach (var subItem in item.ComponentDataList)
                            {
                                AnalyzePlusModule(subItem, TenantId, MallBaseId, UserId);
                            }
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改小程序模板
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetMiniprogramTemplateModule(RB_Miniprogram_Template_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Miniprogram_Template_Extend.Id),extModel.Id }
                };
                fileds.Add(nameof(RB_Miniprogram_Template_Extend.TemplateName), extModel.TemplateName);
                fileds.Add(nameof(RB_Miniprogram_Template_Extend.TemplateData), extModel.TemplateData);
                flag = miniprogram_TemplateRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Template_Extend.Id), extModel.Id));
            }
            else
            {
                var newId = miniprogram_TemplateRepository.Insert(extModel);
                extModel.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取小程序模板实体
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Miniprogram_Template_Extend GetMiniprogramTemplateModule(object Id)
        {
            RB_Miniprogram_Template_Extend extModel = miniprogram_TemplateRepository.GetEntity<RB_Miniprogram_Template_Extend>(Id);
            if (extModel == null)
            {
                extModel = new RB_Miniprogram_Template_Extend();
            }
            if (extModel.TemplateData != null && !string.IsNullOrEmpty(extModel.TemplateData))
            {
                extModel.ComponentDataList = JsonHelper.DeserializeObject<List<ComponentItem>>(extModel.TemplateData);
                if (extModel.ComponentDataList != null && extModel.ComponentDataList.Count > 0)
                {
                    foreach (var item in extModel.ComponentDataList)
                    {
                        AnalyzePlusModule(item);
                    }
                }
            }
            return extModel;
        }

        /// <summary>
        /// 解析插件
        /// </summary>
        /// <param name="item"></param>
        public void AnalyzePlusModule(ComponentItem item, int TenantId = 0, int MallBaseId = 0, int UserId = 0)
        {
            switch (item.Id)
            {
                //背景组件
                case "background": item.data = JsonHelper.DeserializeObject<backgroundItem>(item.data.ToString()); break;
                //查找组件
                case "search": item.data = JsonHelper.DeserializeObject<searchItem>(item.data.ToString()); break;
                //导航组件
                case "nav": item.data = JsonHelper.DeserializeObject<navItem>(item.data.ToString()); break;
                //轮播广告插件
                case "banner": item.data = JsonHelper.DeserializeObject<bannerItem>(item.data.ToString()); break;
                //公告组件
                case "notice":
                    noticeItem nModel = new noticeItem();
                    try
                    {
                        JObject nObj = JObject.Parse(item.data.ToString());
                        nModel.name = (nObj["name"] != null && !string.IsNullOrEmpty(nObj["name"].ToString())) ? nObj["name"].ToString() : "公告";
                        nModel.content = (nObj["content"] != null && !string.IsNullOrEmpty(nObj["content"].ToString())) ? nObj["content"].ToString() : "";
                        nModel.icon = (nObj["icon"] != null && !string.IsNullOrEmpty(nObj["icon"].ToString())) ? nObj["icon"].ToString() : "";
                        nModel.textColor = (nObj["textColor"] != null && !string.IsNullOrEmpty(nObj["textColor"].ToString())) ? nObj["textColor"].ToString() : "#ffffff";
                        nModel.background = (nObj["background"] != null && !string.IsNullOrEmpty(nObj["background"].ToString())) ? nObj["background"].ToString() : "#f67f79";
                        nModel.headerUrl = (nObj["headerUrl"] != null && !string.IsNullOrEmpty(nObj["headerUrl"].ToString())) ? nObj["headerUrl"].ToString() : "";
                        nModel.btnColor = (nObj["btnColor"] != null && !string.IsNullOrEmpty(nObj["btnColor"].ToString())) ? nObj["btnColor"].ToString() : "#ff4544";

                        Int32.TryParse(nObj["btnWidth"].ToString(), out int btnWidth);
                        nModel.btnWidth = btnWidth > 0 ? btnWidth : 500;

                        Int32.TryParse(nObj["btnHeight"].ToString(), out int btnHeight);
                        nModel.btnHeight = btnHeight > 0 ? btnHeight : 80;

                        Int32.TryParse(nObj["btnRadius"].ToString(), out int btnRadius);
                        nModel.btnRadius = btnRadius > 0 ? btnRadius : 40;

                        nModel.btnText = (nObj["btnText"] != null && !string.IsNullOrEmpty(nObj["btnText"].ToString())) ? nObj["btnText"].ToString() : "我知道了";
                        nModel.btnTextColor = (nObj["btnTextColor"] != null && !string.IsNullOrEmpty(nObj["btnTextColor"].ToString())) ? nObj["btnTextColor"].ToString() : "#ffffff";
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "AnalyzePlusModule_notice:" + item.data.ToString());
                    }
                    item.data = nModel;
                    break;
                //专题
                case "topic": item.data = JsonHelper.DeserializeObject<topicItem>(item.data.ToString()); break;
                //标题组件
                case "link": item.data = JsonHelper.DeserializeObject<linkItem>(item.data.ToString()); break;
                //图片广告插件
                case "rubik":
                    JObject jObj = JObject.Parse(item.data.ToString());
                    Int32.TryParse(jObj["style"].ToString(), out int style);
                    Int32.TryParse(jObj["space"].ToString(), out int space);
                    Int32.TryParse(jObj["h"].ToString(), out int h_root);
                    Int32.TryParse(jObj["w"].ToString(), out int w_root);
                    var subData = new rubikItem()
                    {
                        style = style,
                        space = space,
                        height = jObj["height"].ToString(),
                        w = w_root.ToString(),
                        h = h_root,
                        hotspot = new List<hotspotItem>(),
                        list = new List<rubikDetailItem>(),
                        left = jObj.ContainsKey("left") ? jObj["left"].ToString() : "0",
                        right = jObj.ContainsKey("right") ? jObj["right"].ToString() : "0",
                        top = jObj.ContainsKey("top") ? jObj["top"].ToString() : "0",
                        bottom = jObj.ContainsKey("bottom") ? jObj["bottom"].ToString() : "0",
                        background = jObj.ContainsKey("background") ? jObj["background"].ToString() : "",
                    };

                    if (!string.IsNullOrWhiteSpace(jObj["hotspot"].ToString()))
                    {
                        subData.hotspot = Common.Plugin.JsonHelper.DeserializeObject<List<hotspotItem>>(jObj["hotspot"].ToString());
                    }
                    if (!string.IsNullOrWhiteSpace(jObj["list"].ToString()))
                    {
                        JArray jArray = JArray.Parse(jObj["list"].ToString());
                        if (jArray != null && jArray.Count > 0)
                        {
                            foreach (var subItem in jArray)
                            {
                                Int32.TryParse(subItem["w"].ToString(), out int w);
                                Int32.TryParse(subItem["h"].ToString(), out int h2);
                                Int32.TryParse(subItem["x"].ToString(), out int x);
                                Int32.TryParse(subItem["y"].ToString(), out int y);
                                int zIndex = 0;
                                if (subItem["zIndex"] != null && !string.IsNullOrWhiteSpace(subItem["zIndex"].ToString()))
                                {
                                    Int32.TryParse(subItem["zIndex"].ToString(), out zIndex);
                                }
                                var links = new List<rubikLinkItem>();
                                if (subItem["link"] != null && !string.IsNullOrWhiteSpace(subItem["link"].ToString()))
                                {
                                    try
                                    {
                                        var linkObj = JObject.Parse(subItem["link"].ToString());
                                        links.Add(new rubikLinkItem()
                                        {
                                            PageName = linkObj["name"].ToString(),
                                            PageUrl = linkObj["value"].ToString(),
                                            new_link_url = linkObj["new_link_url"].ToString(),
                                            IsParameter = 0,
                                            ParameterValue = linkObj["name"].ToString(),
                                        });
                                    }
                                    catch
                                    {

                                    }
                                    try
                                    {
                                        var linkArray = JArray.Parse(subItem["link"].ToString());
                                        if (linkArray != null && linkArray.Count > 0)
                                        {
                                            foreach (var linkItem in linkArray)
                                            {
                                                var linkModel = new rubikLinkItem() { IsParameter = 0 };
                                                if (linkItem["name"] != null && !string.IsNullOrWhiteSpace(linkItem["name"].ToString()))
                                                {
                                                    linkModel.PageName = linkItem["name"].ToString();
                                                }
                                                if (string.IsNullOrWhiteSpace(linkModel.PageName))
                                                {
                                                    linkModel.PageName = linkItem["PageName"].ToString();
                                                }
                                                if (linkItem["value"] != null && !string.IsNullOrWhiteSpace(linkItem["value"].ToString()))
                                                {
                                                    linkModel.PageUrl = linkItem["value"].ToString();
                                                }
                                                if (string.IsNullOrWhiteSpace(linkModel.PageUrl))
                                                {
                                                    linkModel.PageUrl = linkItem["PageUrl"].ToString();
                                                }
                                                if (linkItem["new_link_url"] != null && !string.IsNullOrWhiteSpace(linkItem["new_link_url"].ToString()))
                                                {
                                                    linkModel.new_link_url = linkItem["new_link_url"].ToString();
                                                }
                                                if (string.IsNullOrWhiteSpace(linkModel.new_link_url))
                                                {
                                                    linkModel.new_link_url = linkItem["PageUrl"].ToString();
                                                }
                                                if (linkItem["name"] != null && !string.IsNullOrWhiteSpace(linkItem["name"].ToString()))
                                                {
                                                    linkModel.ParameterValue = linkItem["name"].ToString();
                                                }
                                                if (string.IsNullOrWhiteSpace(linkModel.ParameterValue))
                                                {
                                                    linkModel.ParameterValue = linkItem["ParameterValue"].ToString();
                                                }
                                                links.Add(linkModel);
                                            }
                                        }
                                    }
                                    catch
                                    {

                                    }
                                }
                                try
                                {
                                    var rubikModel = new rubikDetailItem()
                                    {
                                        w = w,
                                        h = h2,
                                        x = x,
                                        y = y,
                                        link = links,
                                        zIndex = zIndex,
                                        width = "",
                                        height = "",
                                        left = "",
                                        top = "",
                                        pic_url = "",
                                        backgroundImage = "",
                                        backgroundRepeat = "",
                                        backgroundSize = "",
                                        backgroundPosition = "",
                                        backgroundColor = ""
                                    };
                                    if (subItem["width"] != null && !string.IsNullOrWhiteSpace(subItem["width"].ToString()))
                                    {
                                        rubikModel.width = subItem["width"].ToString();
                                    }
                                    if (subItem["height"] != null && !string.IsNullOrWhiteSpace(subItem["height"].ToString()))
                                    {
                                        rubikModel.height = subItem["height"].ToString();
                                    }
                                    if (subItem["left"] != null && !string.IsNullOrWhiteSpace(subItem["left"].ToString()))
                                    {
                                        rubikModel.left = subItem["left"].ToString();
                                    }
                                    if (subItem["top"] != null && !string.IsNullOrWhiteSpace(subItem["top"].ToString()))
                                    {
                                        rubikModel.top = subItem["top"].ToString();
                                    }
                                    if (subItem["pic_url"] != null && !string.IsNullOrWhiteSpace(subItem["pic_url"].ToString()))
                                    {
                                        rubikModel.pic_url = Common.Config.GetFileUrl(subItem["pic_url"].ToString());
                                    }
                                    if (subItem["backgroundImage"] != null && !string.IsNullOrWhiteSpace(subItem["backgroundImage"].ToString()))
                                    {
                                        rubikModel.backgroundImage = Common.Config.GetFileUrl(subItem["backgroundImage"].ToString());
                                    }
                                    if (subItem["backgroundRepeat"] != null && !string.IsNullOrWhiteSpace(subItem["backgroundRepeat"].ToString()))
                                    {
                                        rubikModel.backgroundRepeat = subItem["backgroundRepeat"].ToString();
                                    }
                                    if (subItem["backgroundSize"] != null && !string.IsNullOrWhiteSpace(subItem["backgroundSize"].ToString()))
                                    {
                                        rubikModel.backgroundSize = subItem["backgroundSize"].ToString();
                                    }
                                    if (subItem["backgroundPosition"] != null && !string.IsNullOrWhiteSpace(subItem["backgroundPosition"].ToString()))
                                    {
                                        rubikModel.backgroundPosition = subItem["backgroundPosition"].ToString();
                                    }
                                    if (subItem["backgroundColor"] != null && !string.IsNullOrWhiteSpace(subItem["backgroundColor"].ToString()))
                                    {
                                        rubikModel.backgroundColor = subItem["backgroundColor"].ToString();
                                    }
                                    subData.list.Add(rubikModel);
                                }
                                catch
                                {

                                }
                            }
                        }
                    }
                    item.data = subData;
                    break;
                //视频插件
                case "video":
                    videoItem videoData = new videoItem();
                    try
                    {
                        var video = JsonHelper.DeserializeObject<videoItem>(item.data.ToString());
                        videoData.pic_url = video?.pic_url ?? "";
                        videoData.url = video?.url ?? "";
                        videoData.top = video?.top ?? "0";
                        videoData.bottom = video?.bottom ?? "0";
                        videoData.left = video?.left ?? "0";
                        videoData.right = video?.right ?? "0";
                        videoData.isfullscreen = video?.isfullscreen ?? false;
                        videoData.backgroundimage = video?.backgroundimage ?? "";
                        videoData.radius = video?.radius ?? "0";
                    }
                    catch
                    {

                    }
                    item.data = videoData;
                    break;
                //商品插件
                case "goods": item.data = JsonHelper.DeserializeObject<goodsItem>(item.data.ToString()); break;
                //门店插件
                case "store": item.data = JsonHelper.DeserializeObject<storeItem>(item.data.ToString()); break;
                //版权插件
                case "copyright": item.data = JsonHelper.DeserializeObject<copyrightItem>(item.data.ToString()); break;
                //签到插件
                case "check-in": item.data = JsonHelper.DeserializeObject<checkinItem>(item.data.ToString()); break;
                //用户信息插件
                case "user-info": item.data = JsonHelper.DeserializeObject<userinfoItem>(item.data.ToString()); break;
                //用户订单插件
                case "user-order": item.data = JsonHelper.DeserializeObject<userorderItem>(item.data.ToString()); break;
                //地图插件
                case "map": item.data = JsonHelper.DeserializeObject<mapItem>(item.data.ToString()); break;
                //微信公众号插件
                case "mp-link": item.data = JsonHelper.DeserializeObject<mplinkItem>(item.data.ToString()); break;
                //图文插件
                case "image-text":
                    imagetextItem imageItem = new imagetextItem();
                    try
                    {
                        var imgData = JsonHelper.DeserializeObject<imagetextItem>(item.data.ToString());
                        imageItem.content = imgData.content.Replace('”', '"').Replace("”/", @"""");
                    }
                    catch
                    {

                    }
                    item.data = imageItem;
                    break;
                //优惠券插件
                case "coupon": item.data = JsonHelper.DeserializeObject<couponItem>(item.data.ToString()); break;
                //倒计时插件
                case "timer": item.data = JsonHelper.DeserializeObject<timerItem>(item.data.ToString()); break;
                //拼团插件
                case "pintuan": item.data = JsonHelper.DeserializeObject<pintuanItem>(item.data.ToString()); break;
                //预约插件
                case "booking": item.data = JsonHelper.DeserializeObject<bookingItem>(item.data.ToString()); break;
                //砍价插件
                case "bargain": item.data = JsonHelper.DeserializeObject<bargainItem>(item.data.ToString()); break;
                //积分商城插件
                case "integral-mall": item.data = JsonHelper.DeserializeObject<integralmallItem>(item.data.ToString()); break;
                //抽奖插件
                case "lottery": item.data = JsonHelper.DeserializeObject<lotteryItem>(item.data.ToString()); break;
                //预售
                case "advance": item.data = JsonHelper.DeserializeObject<advanceItem>(item.data.ToString()); break;
                //超级会员卡
                case "vip-card": item.data = JsonHelper.DeserializeObject<vipcardItem>(item.data.ToString()); break;
                //直播组件
                case "live": item.data = JsonHelper.DeserializeObject<liveItem>(item.data.ToString()); break;
                //空白块组件
                case "empty": item.data = JsonHelper.DeserializeObject<emptyItem>(item.data.ToString()); break;
                //流量主广告
                case "ad": item.data = JsonHelper.DeserializeObject<adItem>(item.data.ToString()); break;
                //弹窗广告
                case "modal": item.data = JsonHelper.DeserializeObject<modalItem>(item.data.ToString()); break;
                //快捷导航
                case "quick-nav": item.data = JsonHelper.DeserializeObject<quicknavItem>(item.data.ToString()); break;
                //店铺用户信息
                case "shop-info":
                    shopinfoItem shopModel = new shopinfoItem();
                    try
                    {
                        var shopInfoData = JsonHelper.DeserializeObject<shopinfoItem>(item.data.ToString());
                        if (shopInfoData != null)
                        {
                            shopModel.headImg = shopInfoData?.headImg ?? "";
                            shopModel.headName = shopInfoData?.headName ?? "";
                            shopModel.headInfo = shopInfoData?.headInfo ?? "";
                            shopModel.backgroundPicUrl = shopInfoData?.backgroundPicUrl ?? "";
                            shopModel.backgroundColor = shopInfoData?.backgroundColor ?? "";
                            shopModel.bottonImg = shopInfoData?.bottonImg ?? "";
                            shopModel.fontColor = shopInfoData?.fontColor ?? "";
                            shopModel.fontName = shopInfoData?.fontName ?? "";
                            shopModel.fontSize = shopInfoData?.fontSize ?? "13";
                            shopModel.isBold = shopInfoData?.isBold ?? "false";
                        }
                    }
                    catch
                    {

                    }
                    item.data = shopModel;
                    break;
                //司导插件
                case "drive-guide":
                    driveGuideItem driveModel = new driveGuideItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<driveGuideItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            driveModel.SearchBackground = driveData?.SearchBackground ?? "";
                            driveModel.SearchTips = driveData?.SearchTips ?? "";
                            driveModel.IsShowDate = driveData?.IsShowDate ?? 1;
                            driveModel.IsShowCity = driveData?.IsShowCity ?? 1;
                            driveModel.IsShowAddress = driveData?.IsShowAddress ?? 1;
                            driveModel.IsShowCarpooling = driveData?.IsShowCarpooling ?? 1;
                            driveModel.IsShowGuideCarGoodsType = driveData?.IsShowGuideCarGoodsType ?? 1;
                            driveModel.IsShowCarClass = driveData?.IsShowCarClass ?? 1;
                            driveModel.IsShowTravelGuestNum = driveData?.IsShowTravelGuestNum ?? 1;
                            driveModel.Tips = driveData?.Tips ?? "每辆车都会配备一名专业导游，方便游客出行";
                            driveModel.TipsIco = driveData?.TipsIco ?? Common.Config.GetFileUrl("/Static/dir_icon.png");
                            driveModel.SearchIco = driveData?.SearchIco ?? "";
                            driveModel.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            driveModel.ButtonFilletPX = driveData?.ButtonFilletPX ?? 0;
                            driveModel.ButtonText = driveData?.ButtonText ?? "去订车";
                            driveModel.ButtonColor = driveData?.ButtonColor ?? "#FF4048";
                            driveModel.ButtonTextColor = driveData?.ButtonTextColor ?? "#fff";
                            driveModel.PaddingTop = driveData?.PaddingTop ?? "0";
                            driveModel.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            driveModel.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            driveModel.PaddingRight = driveData?.PaddingRight ?? "0";
                        }
                    }
                    catch
                    {
                    }
                    item.data = driveModel;
                    break;
                //教育模块-最近学习组件
                case "education":
                    educationItem educationModel = new educationItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<educationItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            educationModel.Cover = driveData?.Cover ?? "";
                            educationModel.Name = driveData?.Name ?? "";
                            educationModel.showProgress = driveData?.showProgress ?? 0;
                            educationModel.BtnPosition = driveData?.BtnPosition ?? "left";
                            educationModel.PaddingTop = driveData?.PaddingTop ?? "0";
                            educationModel.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            educationModel.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            educationModel.PaddingRight = driveData?.PaddingRight ?? "0";
                        }
                    }
                    catch
                    {
                    }
                    item.data = educationModel;
                    break;
                //教育模块-自定义列表
                case "educationCustom":
                    educationCustomItem educationCustomModel = new educationCustomItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<educationCustomItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            educationCustomModel.goodsLength = driveData?.goodsLength ?? 1;
                            educationCustomModel.listStyle = driveData?.listStyle ?? 1;
                            educationCustomModel.backgroundColor = driveData?.backgroundColor ?? "";
                            educationCustomModel.PaddingTop = driveData?.PaddingTop ?? "0";
                            educationCustomModel.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            educationCustomModel.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            educationCustomModel.PaddingRight = driveData?.PaddingRight ?? "0";
                            educationCustomModel.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            educationCustomModel.list = new List<CustomDetailsItem2>();
                            educationCustomModel.list = driveData.list;
                        }
                    }
                    catch
                    {
                    }
                    item.data = educationCustomModel;
                    break;

                //教育模块-资讯列表
                case "educationArticle":
                    educationArticleItem educationArticleModel = new educationArticleItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<educationArticleItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            educationArticleModel.goodsLength = driveData?.goodsLength ?? 1;
                            educationArticleModel.addGoodsType = driveData?.addGoodsType ?? 0;
                            educationArticleModel.listStyle = driveData?.listStyle ?? 1;
                            educationArticleModel.backgroundColor = driveData?.backgroundColor ?? "";
                            educationArticleModel.PaddingTop = driveData?.PaddingTop ?? "0";
                            educationArticleModel.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            educationArticleModel.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            educationArticleModel.PaddingRight = driveData?.PaddingRight ?? "0";
                            educationArticleModel.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            educationArticleModel.list = new List<CustomDetailsItem2>();
                            educationArticleModel.list = driveData.list;
                        }
                    }
                    catch
                    {
                    }
                    item.data = educationArticleModel;
                    break;
                //教育模块-老师列表
                case "educationteacher":
                    educationTeacherItem educationTeacherModel = new educationTeacherItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<educationTeacherItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            educationTeacherModel.listStyle = driveData?.listStyle ?? 1;
                            educationTeacherModel.backgroundColor = driveData?.backgroundColor ?? "";
                            educationTeacherModel.PaddingTop = driveData?.PaddingTop ?? "0";
                            educationTeacherModel.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            educationTeacherModel.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            educationTeacherModel.PaddingRight = driveData?.PaddingRight ?? "0";
                            educationTeacherModel.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            educationTeacherModel.TeacherList = new List<TeacherDetailsItem>();
                            educationTeacherModel.TeacherList = driveData.TeacherList;
                        }
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "AnalyzePlusModule_educationteacher");
                    }
                    item.data = educationTeacherModel;
                    break;
                //商品插件
                case "storeGoods": item.data = JsonHelper.DeserializeObject<StoreGoodsItem>(item.data.ToString()); break;
                case "reservestore":
                    ReserveStoreItem storeModel = new ReserveStoreItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<ReserveStoreItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            storeModel.PaddingTop = driveData?.PaddingTop ?? "0";
                            storeModel.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            storeModel.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            storeModel.PaddingRight = driveData?.PaddingRight ?? "0";
                            storeModel.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            storeModel.IsShowStoreImg = driveData?.IsShowStoreImg ?? false;
                        }
                    }
                    catch
                    {
                    }
                    item.data = storeModel;
                    break;
                //教育模块-老师列表
                case "miaiuser":
                    MiAiUserItem miaiUserItem = new MiAiUserItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<MiAiUserItem>(item.data.ToString());
                        if (driveData != null)
                        {

                            if (TenantId > 0 && MallBaseId > 0)
                            {
                                miaiUserItem.listStyle = driveData?.listStyle ?? 1;
                                miaiUserItem.backgroundColor = driveData?.backgroundColor ?? "";
                                miaiUserItem.PaddingTop = driveData?.PaddingTop ?? "0";
                                miaiUserItem.PaddingBottom = driveData?.PaddingBottom ?? "0";
                                miaiUserItem.PaddingLeft = driveData?.PaddingLeft ?? "0";
                                miaiUserItem.PaddingRight = driveData?.PaddingRight ?? "0";
                                miaiUserItem.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                                miaiUserItem.goodsLength = driveData.goodsLength;
                                miaiUserItem.sexType = driveData?.sexType ?? 0;
                                miaiUserItem.addUserType = driveData?.addUserType ?? 0;
                                miaiUserItem.BrowseRate = miaiUserItem.addUserType == 2 ? (miaiUserItem.BrowseRate == 0 ? 1 : miaiUserItem.BrowseRate) : 0;
                                miaiUserItem.FollowRate = miaiUserItem.addUserType == 2 ? (miaiUserItem.FollowRate == 0 ? 1 : miaiUserItem.FollowRate) : 0;
                                miaiUserItem.list = new List<miaiUserDetail>();
                                miaiUserItem.list = driveData.list;
                                int Sex = 0;
                                int Age = 0;
                                if (UserId > 0)//说明用户登录了的
                                {
                                    //查看用户的
                                    var baseInfo = miai_BaseInfoRepository.GetBaseInfoList(new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend { TenantId = TenantId, MallBaseId = MallBaseId, UserId = UserId }).FirstOrDefault();
                                    if (baseInfo != null)
                                    {
                                        Sex = baseInfo.Sex;
                                        if (!string.IsNullOrWhiteSpace(baseInfo.Birthday))
                                        {
                                            try
                                            {
                                                Age = Convert.ToInt32(Common.Plugin.StringHelper.GetAge(baseInfo.Birthday));
                                            }
                                            catch (Exception)
                                            {

                                                Age = 0;
                                            }
                                        }
                                    }
                                    if (miaiUserItem.sexType > 0)
                                    {
                                        Sex = miaiUserItem.sexType == 1 ? 2 : (miaiUserItem.sexType == 2 ? 1 : 0);
                                    }
                                }


                                //自定义商品
                                if (miaiUserItem.addUserType == 0)
                                {
                                    if (miaiUserItem.list != null && miaiUserItem.list.Count > 0)
                                    {
                                        var Ids = "0," + string.Join(",", miaiUserItem.list.Select(qitem => qitem.id));
                                        var tempGoodsList = miai_BaseInfoRepository.GetFirstBaseInfoList(new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                                        {
                                            TenantId = TenantId,
                                            MallBaseId = MallBaseId,
                                            UserIds = Ids,
                                            UserId = UserId
                                        });
                                        List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                                        foreach (var goodItem in miaiUserItem.list)
                                        {
                                            var lastItem = new miaiUserDetail();
                                            var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                            if (tempGood != null && tempGood.Id > 0)
                                            {
                                                lastItem.id = tempGood.UserId;
                                                lastItem.name = tempGood.Name;
                                                lastItem.Photo = tempGood.Photo;
                                                lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                                lastItem.Age = tempGood.Age.ToString(); //Common.Plugin.StringHelper.GetAge(tempGood.Birthday);
                                                lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                                lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";
                                                lastItem.Score = 0;
                                                lastItem.Album = tempGood.Album;
                                                if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                                {
                                                    lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                                }
                                                newGoodsList.Add(lastItem);
                                            }
                                        }
                                        miaiUserItem.list = newGoodsList;
                                    }
                                }
                                else if (miaiUserItem.addUserType == 1)//匹配度暂无规则
                                {
                                    var miaiBaseIfoQuery = new Model.Extend.Miai.RB_MiaiMember_Extend
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        UserId = UserId,
                                        Sex = Sex
                                    };


                                    if (Sex > 0)
                                    {
                                        var queryBaseInfoModel = miai_BaseInfoQueryRepository.GetBaseInfoQueryList(new Model.Entity.Miai.RB_MiAi_BaseInfoQuery
                                        {
                                            TenantId = TenantId,
                                            MallBaseId = MallBaseId,
                                            UserId = UserId,
                                            Sex = Sex == 1 ? 2 : (Sex == 2 ? 1 : 0)
                                        }).FirstOrDefault();

                                        if (queryBaseInfoModel != null && queryBaseInfoModel.Id > 0)
                                        {
                                            miaiBaseIfoQuery.Age = queryBaseInfoModel.Age;
                                            miaiBaseIfoQuery.EndAge = queryBaseInfoModel.EndAge;
                                            miaiBaseIfoQuery.Weight = queryBaseInfoModel.Weight;
                                            miaiBaseIfoQuery.EndWeight = queryBaseInfoModel.EndWeight;
                                            miaiBaseIfoQuery.Height = queryBaseInfoModel.Height;
                                            miaiBaseIfoQuery.EndHeight = queryBaseInfoModel.EndHeight;
                                            miaiBaseIfoQuery.YearMoney = queryBaseInfoModel.YearMoney;
                                            miaiBaseIfoQuery.EndYearMoney = queryBaseInfoModel.EndYearMoney;
                                            miaiBaseIfoQuery.EducationType = queryBaseInfoModel.EducationType;
                                            miaiBaseIfoQuery.CarInfo = queryBaseInfoModel.CarInfo;
                                            miaiBaseIfoQuery.HouseInfo = queryBaseInfoModel.HouseInfo;
                                            miaiBaseIfoQuery.Marriage = queryBaseInfoModel.Marriage;
                                        }
                                    }

                                    var tempGoodsList = miai_BaseInfoRepository.GetMatchingBaseInfoList(miaiBaseIfoQuery, miaiUserItem.goodsLength);
                                    List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                                    foreach (var tempGood in tempGoodsList)
                                    {
                                        var lastItem = new miaiUserDetail();
                                        // var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            lastItem.id = tempGood.UserId;
                                            lastItem.name = tempGood.Name;
                                            lastItem.Photo = tempGood.Photo;
                                            lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                            lastItem.Age = tempGood.Age.ToString();
                                            lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                            lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";

                                            lastItem.Score = 0;
                                            lastItem.Album = tempGood.Album;
                                            if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                            {
                                                lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                            }
                                            newGoodsList.Add(lastItem);
                                        }
                                    }
                                    miaiUserItem.list = newGoodsList;
                                }
                                else if (miaiUserItem.addUserType == 2)
                                {


                                    long rowCount = 0;
                                    var tempGoodsList = miai_BaseInfoRepository.GetFirstBaseInfoPageList(1, miaiUserItem.goodsLength, out rowCount, new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        Sort = 2,
                                        Sex = Sex,
                                        UserId = UserId,
                                        FollowRate = miaiUserItem.FollowRate == 0 ? 1 : miaiUserItem.FollowRate,
                                        BrowseRate = miaiUserItem.BrowseRate == 0 ? 1 : miaiUserItem.BrowseRate,
                                    });
                                    List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                                    foreach (var tempGood in tempGoodsList)
                                    {
                                        var lastItem = new miaiUserDetail();
                                        //  var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            lastItem.id = tempGood.UserId;
                                            lastItem.name = tempGood.Name;
                                            lastItem.Photo = tempGood.Photo;
                                            lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                            lastItem.Age = tempGood.Age.ToString();
                                            lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                            lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";


                                            lastItem.Score = 0;
                                            lastItem.Album = tempGood.Album;
                                            if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                            {
                                                lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                            }
                                            newGoodsList.Add(lastItem);
                                        }
                                    }
                                    miaiUserItem.list = newGoodsList;

                                }

                                else if (miaiUserItem.addUserType == 3)
                                {

                                    long rowCount = 0;
                                    var tempGoodsList = miai_BaseInfoRepository.GetFirstBaseInfoPageList(1, miaiUserItem.goodsLength, out rowCount, new Model.Extend.Miai.RB_MiAi_BaseInfo_Extend
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        Sort = 3,
                                        Sex = Sex,
                                        UserId = UserId
                                    });
                                    List<miaiUserDetail> newGoodsList = new List<miaiUserDetail>();
                                    foreach (var tempGood in tempGoodsList)
                                    {
                                        var lastItem = new miaiUserDetail();
                                        // var tempGood = tempGoodsList?.Where(qitem => qitem.UserId == goodItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            lastItem.id = tempGood.UserId;
                                            lastItem.name = tempGood.Name;
                                            lastItem.Photo = tempGood.Photo;
                                            lastItem.SexStr = tempGood.Sex == 1 ? "男" : "女";
                                            lastItem.Age = tempGood.Age.ToString();
                                            lastItem.Marriage = (tempGood.Marriage.HasValue && tempGood.Marriage.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.Marriage) : "";
                                            lastItem.Education = (tempGood.EducationType.HasValue && tempGood.EducationType.Value > 0) ? Common.Plugin.EnumHelper.GetEnumName(tempGood.EducationType) : "";
                                            lastItem.Score = 0;
                                            lastItem.Album = tempGood.Album;
                                            if (!string.IsNullOrWhiteSpace(lastItem.Album))
                                            {
                                                lastItem.AlbumList = JsonConvert.DeserializeObject<List<string>>(lastItem.Album);
                                            }
                                            newGoodsList.Add(lastItem);
                                        }
                                    }
                                    miaiUserItem.list = newGoodsList;
                                }

                            }
                            else
                            {
                                miaiUserItem.listStyle = driveData?.listStyle ?? 1;
                                miaiUserItem.backgroundColor = driveData?.backgroundColor ?? "";
                                miaiUserItem.PaddingTop = driveData?.PaddingTop ?? "0";
                                miaiUserItem.PaddingBottom = driveData?.PaddingBottom ?? "0";
                                miaiUserItem.PaddingLeft = driveData?.PaddingLeft ?? "0";
                                miaiUserItem.PaddingRight = driveData?.PaddingRight ?? "0";
                                miaiUserItem.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                                miaiUserItem.goodsLength = driveData.goodsLength;
                                miaiUserItem.sexType = driveData?.sexType ?? 0;
                                miaiUserItem.addUserType = driveData?.addUserType ?? 0;
                                miaiUserItem.BrowseRate = miaiUserItem.addUserType == 2 ? (miaiUserItem.BrowseRate == 0 ? 1 : miaiUserItem.BrowseRate) : 0;
                                miaiUserItem.FollowRate = miaiUserItem.addUserType == 2 ? (miaiUserItem.FollowRate == 0 ? 1 : miaiUserItem.FollowRate) : 0;
                                miaiUserItem.list = new List<miaiUserDetail>();
                                miaiUserItem.list = driveData.list;
                            }

                        }
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "miaiuser");
                    }
                    item.data = miaiUserItem;
                    break;

                case "miaiactivitytype":
                    MiAiActivityTypeItem miAiActivityTypeItem = new MiAiActivityTypeItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<MiAiActivityTypeItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            miAiActivityTypeItem.listStyle = driveData?.listStyle ?? 1;
                            miAiActivityTypeItem.backgroundColor = driveData?.backgroundColor ?? "";
                            miAiActivityTypeItem.PaddingTop = driveData?.PaddingTop ?? "0";
                            miAiActivityTypeItem.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            miAiActivityTypeItem.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            miAiActivityTypeItem.PaddingRight = driveData?.PaddingRight ?? "0";
                            miAiActivityTypeItem.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            miAiActivityTypeItem.list = new List<MiAiActivityTypeModel>();
                            miAiActivityTypeItem.list = driveData.list;
                        }
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "miaiuser");
                    }
                    item.data = miAiActivityTypeItem;
                    break;
                case "miaiactivityCustom":
                    MiAiActivityTypeCustomItem miAiActivityTypeCustomItem = new MiAiActivityTypeCustomItem();
                    try
                    {
                        var driveData = JsonHelper.DeserializeObject<MiAiActivityTypeCustomItem>(item.data.ToString());
                        if (driveData != null)
                        {
                            miAiActivityTypeCustomItem.listStyle = driveData?.listStyle ?? 1;
                            miAiActivityTypeCustomItem.backgroundColor = driveData?.backgroundColor ?? "";
                            miAiActivityTypeCustomItem.PaddingTop = driveData?.PaddingTop ?? "0";
                            miAiActivityTypeCustomItem.PaddingBottom = driveData?.PaddingBottom ?? "0";
                            miAiActivityTypeCustomItem.PaddingLeft = driveData?.PaddingLeft ?? "0";
                            miAiActivityTypeCustomItem.PaddingRight = driveData?.PaddingRight ?? "0";
                            miAiActivityTypeCustomItem.SearchFilletPX = driveData?.SearchFilletPX ?? 0;
                            miAiActivityTypeCustomItem.list = new List<MiAiActivityTypeCusModel>();
                            miAiActivityTypeCustomItem.list = driveData.list;
                        }
                    }
                    catch (Exception ex)
                    {
                        Common.Plugin.LogHelper.Write(ex, "miaiuser");
                    }
                    item.data = miAiActivityTypeCustomItem;
                    break;
                //相亲ppplus (招募贴)插件
                case "blindDatePPPlus": item.data = JsonHelper.DeserializeObject<blindDatePPPlusItem>(item.data.ToString()); break;
                //导航-页面
                case "nav-page": item.data = JsonHelper.DeserializeObject<navPageItem>(item.data.ToString()); break;

                //首店-自定义列表
                case "tradePavilionCustom":
                    educationCustomItem tradePavilionCustomModel = new educationCustomItem();
                    try
                    {
                        var tradeData = JsonHelper.DeserializeObject<educationCustomItem>(item.data.ToString());
                        if (tradeData != null)
                        {
                            tradePavilionCustomModel.goodsLength = tradeData?.goodsLength ?? 1;
                            tradePavilionCustomModel.addGoodsType = tradeData?.addGoodsType ?? 1;
                            tradePavilionCustomModel.goodType = tradeData?.goodType ?? 1;
                            tradePavilionCustomModel.listStyle = tradeData?.listStyle ?? 1;
                            tradePavilionCustomModel.backgroundColor = tradeData?.backgroundColor ?? "";
                            tradePavilionCustomModel.PaddingTop = tradeData?.PaddingTop ?? "0";
                            tradePavilionCustomModel.PaddingBottom = tradeData?.PaddingBottom ?? "0";
                            tradePavilionCustomModel.PaddingLeft = tradeData?.PaddingLeft ?? "0";
                            tradePavilionCustomModel.PaddingRight = tradeData?.PaddingRight ?? "0";
                            tradePavilionCustomModel.SearchFilletPX = tradeData?.SearchFilletPX ?? 0;
                            tradePavilionCustomModel.list = new List<CustomDetailsItem2>();
                            tradePavilionCustomModel.list = tradeData.list;
                        }
                    }
                    catch
                    {
                    }
                    item.data = tradePavilionCustomModel;
                    break;
            }
        }

        /// <summary>
        /// 删除小程序模板
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveMiniprogramTemplateModule(object Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Miniprogram_Template_Extend.Status),Status }
            };
            bool flag = miniprogram_TemplateRepository.Update(fileds, new WhereHelper(nameof(RB_Miniprogram_Template_Extend.Id), Id));
            return flag;
        }
    }
}
