﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    public class RB_Distributor_FXCommissionRepository : RepositoryBase<RB_Distributor_FXCommission>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Distributor_FXCommission); } }
        /// <summary>
        /// 返佣分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXCommission_Extend> GetFXCommissionPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_FXCommission_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Distributor_FXCommission_Extend.Status)}=0");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.FXGradeId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.FXGradeId)}={query.FXGradeId}");
                }
            }
            return GetPage<RB_Distributor_FXCommission_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 返佣列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_FXCommission_Extend> GetFXCommissionList(RB_Distributor_FXCommission_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Distributor_FXCommission_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.FXGradeId > 0)
                {
                    builder.Append($" AND {nameof(RB_Distributor_FXCommission_Extend.FXGradeId)}={query.FXGradeId}");
                }
            }
            return Get<RB_Distributor_FXCommission_Extend>(builder.ToString()).ToList();
        }
    }
}
