﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 图片魔方表仓储层
    /// </summary>
    public class RB_Mall_MagicRepository : RepositoryBase<RB_Mall_Magic>
    {
        /// <summary>
        /// 图片魔方分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Mall_Magic_Extend> GetMallMagicPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Mall_Magic_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Mall_Magic WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Magic_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Magic_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Magic_Extend.Id), query.Id);
            }
            if (query.Name != null && !string.IsNullOrEmpty(query.Name.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Mall_Magic_Extend.Name), query.Name.Trim());
            }
            return GetPage<RB_Mall_Magic_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取图片魔方列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Mall_Magic_Extend> GetMallMagicListRepository(RB_Mall_Magic_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Mall_Magic WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Magic_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Magic_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.Id > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Mall_Magic_Extend.Id), query.Id);
            }
            if (query.Name != null && !string.IsNullOrEmpty(query.Name.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Mall_Magic_Extend.Name), query.Name.Trim());
            }
            return Get<RB_Mall_Magic_Extend>(builder.ToString()).ToList();
        }
    }
}
