﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 账户类型
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_AccountType
    {

        /// <summary>
        /// 编号
        /// </summary>        
        public int ID
        {
            get;
            set;
        }
        /// <summary>
        /// 创建人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 创建日期
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 状态
        /// </summary>        
        public Common.Enum.DateStateEnum? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 类型名称
        /// </summary>        
        public string Name
        {
            get;
            set;
        }
        /// <summary>
        /// 是否对公
        /// </summary>        
        public int? IsPublic
        {
            get;
            set;
        }
        /// <summary>
        /// 虚拟类型
        /// </summary>        
        public int? IsVirtual
        {
            get;
            set;
        }
    }
}
