﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品分类样式表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Product_CategoryStyle
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 分类  1一级样式  2二级样式   3三级样式
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 样式id
        /// </summary>        
        public int? Style
        {
            get;
            set;
        }
        /// <summary>
        /// 每个分类商品显示总数
        /// </summary>        
        public int? CategoryNum
        {
            get;
            set;
        }
        /// <summary>
        /// 商品每行显示的数量
        /// </summary>        
        public int? RowNum
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
