﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 小程序自定义页面导航仓储层
    /// </summary>
    public class RB_Miniprogram_Page_Templ_DetailsRepository : RepositoryBase<RB_Miniprogram_Page_Templ_Details>
    {
        /// <summary>
        /// 小程序自定义页面导航列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Page_Templ_Details_Extend> GetMiniprogramPageTemplDetailsListRepository(RB_Miniprogram_Page_Templ_Details_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Miniprogram_Page_Templ_Details WHERE 1=1 ");
            if (query != null)
            {
                if (query.QPageTemplIDs != null && !string.IsNullOrWhiteSpace(query.QPageTemplIDs.Trim()))
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Page_Templ_Details_Extend.PageTemplID)} IN  ({query.QPageTemplIDs.Trim()}) ");
                }
            }
            return Get<RB_Miniprogram_Page_Templ_Details_Extend>(builder.ToString()).ToList();
        }
    }
}
