﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单物流仓储层
    /// </summary>
    public class RB_Goods_OrderExpressRepository : RepositoryBase<RB_Goods_OrderExpress>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderExpress_Extend> GetList(RB_Goods_OrderExpress_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderExpress.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderExpress.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderExpress.Type)}={dmodel.Type}";
            }
            if (dmodel.ExpressId > 0)
            {
                where += $@" and {nameof(RB_Goods_OrderExpress.ExpressId)}={dmodel.ExpressId}";
            }
            if (!string.IsNullOrEmpty(dmodel.ExpressNumber))
            {
                where += $@" and {nameof(RB_Goods_OrderExpress.ExpressNumber)} like '%{dmodel.ExpressNumber}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderExpressIds)) {
                where += $@" and {nameof(RB_Goods_OrderExpress.Id)} in({dmodel.OrderExpressIds})";
            }
            if (dmodel.AfterSaleOrderId > 0) {
                where += $@" and {nameof(RB_Goods_OrderExpress.AfterSaleOrderId)}={dmodel.AfterSaleOrderId}";
            }

            string sql = $@"SELECT * FROM RB_Goods_OrderExpress where {where} order by Id asc";
            return Get<RB_Goods_OrderExpress_Extend>(sql).ToList();
        }
    }
}
