﻿using Mall.IM.Util;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace Mall.IM.Service.Account
{
    public class AccountService:BaseService
    {
        /// <summary>
        /// 创建网易云通信ID
        /// </summary>
        private const String create = "user/create.action";
        /// <summary>
        /// 更新并获取新token
        /// </summary>
        private const String refreshToken = "user/refreshToken.action";
        /// <summary>
        /// 网易云通信ID更新
        /// </summary>
        private const String update = "user/update.action";
        /// <summary>
        /// 初始默认密码
        /// </summary>
        public const String PASSWORD = "111111";


        /// <summary>
        /// 创建账号
        /// </summary>
        /// <param name="account">网易云通信ID</param>
        /// <param name="name">用户名(昵称)</param>
        /// <param name="icon">头像</param>
        /// <returns></returns>
        public AccountServiceResult CreateAccount(String accid, String name, String icon)
        {
            if (String.IsNullOrWhiteSpace(accid))
                throw new ArgumentNullException("参数异常，为null或accid为空");
            String url = String.Format("{0}?accid={1}&name={2}&icon={3}&token={4}", create, HttpUtility.UrlEncode(accid), HttpUtility.UrlEncode(name), HttpUtility.UrlEncode(icon), PASSWORD);
            var apiResult = ApiRequestUtil.PostResponse<AccountServiceResult>(ServiceAddress, url);
            return apiResult.Data;
        }


        /// <summary>
        /// 更新并获取账号新密码（密码随机生成）
        /// </summary>
        /// <param name="accid">网易云通信ID</param>
        /// <returns></returns>
        public AccountServiceResult RefreshToken(String accid)
        {

            if (String.IsNullOrWhiteSpace(accid))
                throw new ArgumentNullException("参数异常，为null或accid为空");
            String url = String.Format("{0}?accid={1}", refreshToken, HttpUtility.UrlEncode(accid));
            var apiResult = ApiRequestUtil.PostResponse<AccountServiceResult>(ServiceAddress, url);
            return apiResult.Data;
        }

        /// <summary>
        /// 更新账号密码
        /// </summary>
        /// <param name="accid">网易云通信ID</param>
        /// <param name="password">新密码</param>
        /// <returns></returns>
        public Result UpdateAccountPassword(String accid,String password)
        {
            if (String.IsNullOrWhiteSpace(accid))
                throw new ArgumentNullException("参数异常，为null或accid为空");
            String url = String.Format("{0}?accid={1}&token={2}", update, HttpUtility.UrlEncode(accid), password);
            var apiResult = ApiRequestUtil.PostResponse<AccountServiceResult>(ServiceAddress, url);
            return apiResult.Data;
        }

        /// <summary>
        /// 重置用户账号密码
        /// </summary>
        /// <param name="accid">网易云通信ID</param>
        /// <returns></returns>
        public Result ResetAccountPassword(String accid)
        {
            if (String.IsNullOrWhiteSpace(accid))
                throw new ArgumentNullException("参数异常，为null或accid为空");
            String url = String.Format("{0}?accid={1}&token={2}", update, HttpUtility.UrlEncode(accid),PASSWORD);
            var apiResult = ApiRequestUtil.PostResponse<AccountServiceResult>(ServiceAddress, url);
            return apiResult.Data;
        }
    }
}
