﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using Mall.Repository.Education;
using VT.FW.DB;

namespace Mall.Module.Education
{

    /// <summary>
    /// app动态模块
    /// </summary>
    public class DynamicModule
    {
        private readonly Rb_Education_DynamicRepository articleRepository = new Rb_Education_DynamicRepository();
        private readonly Rb_Education_DynamicLikeRepository likeRepository = new Rb_Education_DynamicLikeRepository();
        private readonly Rb_Education_DynamicCommentRepository commentRepository = new Rb_Education_DynamicCommentRepository();
        private readonly Rb_Education_DynamicMessageRepository messageRepository = new Rb_Education_DynamicMessageRepository();


        /// <summary>
        /// 获取消息未读数
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <returns></returns>
        public int GetDynamicMessageCount(Rb_Education_DynamicMessage model)
        {
            return messageRepository.GetDynamicMessageCount(model);
        }

        /// <summary>
        /// 发布动态文章
        /// </summary>
        /// <param name="article">动态文章</param>
        /// <returns></returns>
        public bool PublishDynamic(Rb_Education_Dynamic article)
        {
            return articleRepository.Insert(article) > 0 ? true : false;
        }

        ///// <summary>
        ///// 我的动态记录
        ///// </summary>
        ///// <param name="empId">员工id</param>
        ///// <param name="pageIndex">当前页</param>
        ///// <param name="pageSize">分页大小</param>
        ///// <param name="count">总条数</param>
        ///// <returns></returns>
        //public List<Rb_Education_Dynamic_Extend> MyDynamicList(int empId, int pageIndex, int pageSize, out long count)
        //{
        //    List<Rb_Education_Dynamic_Extend> articleList = articleRepository.MyDynamicList(empId, pageIndex, pageSize, out count);
        //    return articleList;
        //}
        /// <summary>
        ///// Web端我的动态记录
        ///// </summary>
        ///// <param name="empId">员工id</param>
        ///// <param name="groupId">集团id</param>
        ///// <param name="pageIndex">当前页</param>
        ///// <param name="pageSize">分页大小</param>
        ///// <param name="count">总条数</param>
        ///// <returns></returns>
        //public List<Rb_Education_Dynamic_Extend> WebMyDynamicList(int empId, int groupId, int pageIndex, int pageSize, out long count)
        //{
        //    List<Rb_Education_Dynamic_Extend> articleList = articleRepository.WebMyDynamicList(empId, groupId, pageIndex, pageSize, out count);
        //    DecoratorDynameicArticle(articleList);
        //    return articleList;
        //}
        /// <summary>
        /// 集团动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> DynamicList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            List<Rb_Education_Dynamic_Extend> articleList = new List<Rb_Education_Dynamic_Extend>();
            if (model.UserId > 0)//关注并公开
            {
                articleList = articleRepository.DynamicOpenList(pageIndex, pageSize, out count, model);
            }
            else
            {//公开的
                articleList = articleRepository.DynamicList(pageIndex, pageSize, out count, model);
            }
            DecoratorDynameicArticle(articleList);
            return articleList;
        }

        /// <summary>
        /// 我的动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> MyDynamicList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            List<Rb_Education_Dynamic_Extend> articleList = articleRepository.MyDynamicList(pageIndex, pageSize, out count, model);

            DecoratorDynameicArticle(articleList);
            return articleList;
        }


        /// <summary>
        /// 与我相关的动态
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> AboutMeDynamicList(Rb_Education_Dynamic_Extend model, int pageIndex, int pageSize, out long count)
        {
            if (pageIndex == 1)
            {
                IList<WhereHelper> messageWhereHelpers = new List<WhereHelper>
                        {
                            new WhereHelper()
                            {
                                FiledName = nameof(Rb_Education_DynamicMessage.UserId),
                                FiledValue = model.CreateBy,
                                OperatorEnum = OperatorEnum.Equal
                            }
                        };
                messageRepository.Delete(messageWhereHelpers);
            }
            return articleRepository.AboutMeDynamicList(model, pageIndex, pageSize, out count);
        }
        /// <summary>
        /// 装饰动态文章
        /// </summary>
        /// <param name="articleList"></param>
        private void DecoratorDynameicArticle(List<Rb_Education_Dynamic_Extend> articleList)
        {
            List<Rb_Education_DynamicLike_Extend> likeList = new List<Rb_Education_DynamicLike_Extend>();
            List<Rb_Education_DynamicComment_Extend> commentList = new List<Rb_Education_DynamicComment_Extend>();
            if (articleList != null && articleList.Any())
            {
                string articleIds = string.Join(",", articleList.Where(x => x.Id > 0).Select(x => x.Id));
                if (!string.IsNullOrWhiteSpace(articleIds))
                {
                    likeList = likeRepository.GetDynamicLikeList(new Rb_Education_DynamicLike_Extend { ArticleIds = articleIds });
                    commentList = commentRepository.GetDynamicCommentList(new Rb_Education_DynamicComment_Extend { ArticleIds = articleIds });
                }
            }
            foreach (var item in articleList)
            {
                item.LikeList = likeList.Where(x => x.ArticleId == item.Id).ToList();
                item.CommentList = commentList.Where(x => x.ArticleId == item.Id).ToList();
                foreach (var common in item.CommentList)
                {
                    if (common.CommentId != null && common.CommentId > 0)
                    {
                        Rb_Education_DynamicComment_Extend byReplayCommon = item.CommentList.Where(t => t.Id == common.CommentId.Value).FirstOrDefault();
                        if (byReplayCommon != null)
                        {
                            common.ByReplyEmName = byReplayCommon.UserName;
                            common.ByReplyEmpId = byReplayCommon.UserId;
                        }
                    }
                }
            }
        }





        /// <summary>
        /// 获取动态点赞
        /// </summary>
        /// <param name="articleId">动态文章id</param>
        /// <returns></returns>
        public List<Rb_Education_DynamicLike_Extend> GetDynamicLikeList(Rb_Education_DynamicLike_Extend model)
        {
            return likeRepository.GetDynamicLikeList(model);
        }


        /// <summary>
        /// 获取动态详情
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="articleId">动态id</param>
        /// <returns></returns>
        public Rb_Education_Dynamic_Extend GetDynamicDetial(Rb_Education_Dynamic_Extend model)
        {
            Rb_Education_Dynamic_Extend article = articleRepository.GetDynamicDetial(model);
            if (article == null)
            {
                return article;
            }
            article.LikeList = likeRepository.GetDynamicLikeList(new Rb_Education_DynamicLike_Extend { ArticleId = article.Id });
            article.CommentList = commentRepository.GetDynamicCommentList(new Rb_Education_DynamicComment_Extend { ArticleId = article.Id });
            foreach (var common in article.CommentList)
            {
                if (common.CommentId != null && common.CommentId > 0)
                {
                    Rb_Education_DynamicComment_Extend byReplayCommon = article.CommentList.Where(t => t.Id == common.CommentId.Value).FirstOrDefault();
                    if (byReplayCommon != null)
                    {
                        common.ByReplyEmName = byReplayCommon.UserName;
                        common.ByReplyEmpId = byReplayCommon.UserId;
                    }
                }
            }
            return article;
        }

        /// <summary>
        /// 删除动态
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="articleId">动态id</param>
        /// <returns></returns>
        public bool DeleteDynamic(int createBy, int articleId, int tenantId, int mallBaseId)
        {
            IDictionary<string, object> fileds = new Dictionary<string, object>
                {
                    { nameof(Rb_Education_Dynamic.Status), 1 }
                };
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_Dynamic.Id),
                            FiledValue = articleId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_Dynamic.TenantId),
                            FiledValue = tenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_Dynamic.MallBaseId),
                            FiledValue = mallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                        new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_Dynamic.CreateBy),
                            FiledValue = createBy,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            return articleRepository.Update(fileds, auditrecordWhereHelpers);
        }

        /// <summary>
        /// 动态点赞
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="articleId">文章id</param>
        /// <returns></returns>
        public bool DynamicLike(Rb_Education_DynamicLike model)
        {
            var trans = likeRepository.DbTransaction;
            try
            {
                IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicLike.ArticleId),
                            FiledValue = model.ArticleId,
                            OperatorEnum = OperatorEnum.Equal
                        }, new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicLike.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        }, new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicLike.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                        new WhereHelper(){
                            FiledName = nameof(Rb_Education_DynamicLike.UserId),
                            FiledValue = model.UserId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                likeRepository.Delete(auditrecordWhereHelpers, trans);
                Rb_Education_DynamicLike like = new Rb_Education_DynamicLike
                {
                    CreateTime = DateTime.Now,
                    ArticleId = model.ArticleId,
                    UserId = model.UserId,
                    TenantId = model.TenantId,
                    MallBaseId = model.MallBaseId
                };
                int likeId = likeRepository.Insert(like, trans);

                Rb_Education_Dynamic article = articleRepository.GetEntity(model.ArticleId);
                if (article != null)
                {
                    Rb_Education_DynamicMessage message = new Rb_Education_DynamicMessage
                    {
                        UserId = article.CreateBy,
                        CreateTime = DateTime.Now,
                        ArticleId = model.ArticleId,
                        MessageId = likeId,
                        MessageType = 2,
                        TenantId = article.TenantId,
                        MallBaseId = article.MallBaseId
                    };
                    messageRepository.Insert(message, trans);
                }
                likeRepository.DBSession.Commit();
                return true;
            }
            catch (Exception)
            {
                likeRepository.DBSession.Rollback("DynamicLike");
                return false;
            }
        }

        /// <summary>
        /// 动态取消点赞
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="articleId">文章id</param>
        /// <returns></returns>
        public void DynamicCancelLike(Rb_Education_DynamicLike model)
        {
            IList<WhereHelper> auditrecordWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicLike.Id),
                            FiledValue = model.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicLike.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },  new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicLike.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                        new WhereHelper(){
                            FiledName = nameof(Rb_Education_DynamicLike.UserId),
                            FiledValue = model.UserId,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            likeRepository.Delete(auditrecordWhereHelpers);


            IList<WhereHelper> messageWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicMessage.MessageId),
                            FiledValue = model.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicMessage.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicMessage.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                        new WhereHelper(){
                            FiledName = nameof(Rb_Education_DynamicMessage.MessageType),
                            FiledValue = 2,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
            messageRepository.Delete(messageWhereHelpers);
        }

        /// <summary>
        /// 添加动态评论
        /// </summary>
        /// <param name="comment">评论信息</param>
        /// <returns></returns>
        public bool DynamicCommemt(Rb_Education_DynamicComment comment)
        {
            int commentId = commentRepository.Insert(comment);
            if (commentId > 0)
            {
                Rb_Education_Dynamic article = articleRepository.GetEntity(comment.ArticleId);
                if (article != null)
                {
                    Rb_Education_DynamicMessage message = new Rb_Education_DynamicMessage
                    {
                        UserId = article.CreateBy,
                        CreateTime = DateTime.Now,
                        ArticleId = comment.ArticleId,
                        MessageId = commentId,
                        MessageType = 1,
                        TenantId = article.TenantId,
                        MallBaseId = article.MallBaseId
                    };
                    messageRepository.Insert(message);
                }
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// 删除动态评论
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="commentId">评论id</param>
        /// <returns></returns>
        public bool DynamicDeleteComment(Rb_Education_DynamicComment_Extend model)
        {
            if (commentRepository.DynamicDeleteComment(model) > 0)
            {
                IList<WhereHelper> messageWhereHelpers = new List<WhereHelper>
                    {
                        new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicMessage.MessageId),
                            FiledValue = model.Id,
                            OperatorEnum = OperatorEnum.Equal
                        },
                         new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicMessage.TenantId),
                            FiledValue = model.TenantId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                          new WhereHelper()
                        {
                            FiledName = nameof(Rb_Education_DynamicMessage.MallBaseId),
                            FiledValue = model.MallBaseId,
                            OperatorEnum = OperatorEnum.Equal
                        },
                        new WhereHelper(){
                            FiledName = nameof(Rb_Education_DynamicMessage.MessageType),
                            FiledValue = 1,
                            OperatorEnum = OperatorEnum.Equal
                        }
                    };
                messageRepository.Delete(messageWhereHelpers);
                return true;
            }
            else
            {
                return false;
            }
        }


        #region 相亲朋友圈
        /// <summary>
        /// 集团动态列表
        /// </summary>
        /// <param name="empId">员工id</param>
        /// <param name="groupId">集团id</param>
        /// <param name="pageIndex">当前页</param>
        /// <param name="pageSize">分页大小</param>
        /// <param name="count">总条数</param>
        /// <returns></returns>
        public List<Rb_Education_Dynamic_Extend> MiAiDynamicList(int pageIndex, int pageSize, out long count, Rb_Education_Dynamic_Extend model)
        {
            List<Rb_Education_Dynamic_Extend> articleList = new List<Rb_Education_Dynamic_Extend>();
            if (model.UserId > 0)//关注并公开
            {
                articleList = articleRepository.MiAiDynamicOpenList(pageIndex, pageSize, out count, model);
            }
            else
            {//公开的
                articleList = articleRepository.MiAiDynamicList(pageIndex, pageSize, out count, model);
            }
            DecoratorDynameicArticle(articleList);
            return articleList;
        }

        #endregion
    }
}
