﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 活动仓储层
    /// </summary>
    public class RB_Miai_ActivityEnrollRepository : BaseRepository<RB_Miai_ActivityEnroll>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_ActivityEnroll_Extend dmodel)
        {
            string where = $" 1=1 and e.{nameof(RB_Miai_ActivityEnroll_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and e.{nameof(RB_Miai_ActivityEnroll_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and e.{nameof(RB_Miai_ActivityEnroll_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ActivityId > 0) {
                where += $@" and e.{nameof(RB_Miai_ActivityEnroll_Extend.ActivityId)} ={dmodel.ActivityId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and e.{nameof(RB_Miai_ActivityEnroll_Extend.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and e.{nameof(RB_Miai_ActivityEnroll_Extend.Id)} ={dmodel.Id}";
            }
            string sql = $@"select e.*,u.Name as UserName,u.Photo,b.Sex from RB_Miai_ActivityEnroll e
left join rb_member_user u on e.UserId = u.Id
left join rb_miai_baseinfo b on e.UserId =b.UserId
where {where} order by e.Id desc";
            return GetPage<RB_Miai_ActivityEnroll_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetList(RB_Miai_ActivityEnroll_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Miai_ActivityEnroll_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.ActivityId)} ={dmodel.ActivityId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.UserId)} ={dmodel.UserId}";
            }
            string sql = $@"select * from RB_Miai_ActivityEnroll where {where} order by Id desc";
            return Get<RB_Miai_ActivityEnroll_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取活动报名人数
        /// </summary>
        /// <param name="activityId"></param>
        /// <returns></returns>
        public int GetActivityEnrollNum(int activityId)
        {
            string sql = $@" select count(0) from RB_Miai_ActivityEnroll where Status =0 and ActivityId ={activityId}";
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToInt32(obj);
        }

        /// <summary>
        /// 获取活动报名人数
        /// </summary>
        /// <param name="activityIds"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetActivityEnrollNumList(string activityIds)
        {
            string sql = $@" select ActivityId,count(0) as Number from RB_Miai_ActivityEnroll where Status =0 and ActivityId in({activityIds}) group by ActivityId";
            return Get<RB_Miai_ActivityEnroll_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取招募贴我的报名记录
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Miai_ActivityEnroll_Extend> GetMyEnrollPageList(int pageIndex, int pageSize, out long count, RB_Miai_ActivityEnroll_Extend dmodel)
        {
            string where = $" 1=1 ";
            if (dmodel.Status >= 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.Status)}={dmodel.Status}";
            }
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.ActivityId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.ActivityId)} ={dmodel.ActivityId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Miai_ActivityEnroll_Extend.UserId)} ={dmodel.UserId}";
            }
            string sql = $@"select * from RB_Miai_ActivityEnroll where {where} order by Id desc";
            return GetPage<RB_Miai_ActivityEnroll_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }
    }
}
