﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Data
{
    /// <summary>
    /// 购物店配置帮助类
    /// </summary>
    public class PriceShopHelper
    {
        static readonly string path = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Data\\CreateBillConfig.json");

        /// <summary>
        /// 地区节点集合
        /// </summary>
        public static List<ShopConfig> ShopConfigList { get; set; }



        /// <summary>
        /// 根据编号获取节点
        /// </summary>
        /// <param name="LineId">线路编号</param>
        /// <returns></returns>
        public static ShopConfig GetShopConfig(int LineId)
        {
            List<ShopConfig> list = GetShopConfigList();
            return list.Find(qitem => qitem.LineID == LineId);
        }

        /// <summary>
        /// 获取地区列表
        /// </summary>
        /// <returns></returns>
        private static List<ShopConfig> GetShopConfigList()
        {
            if (ShopConfigList != null && ShopConfigList.Count > 0)
            {
                return ShopConfigList;
            }
            try
            {
                //读取json文件  
                using (StreamReader file = new StreamReader(path))
                {
                    try
                    {
                        JsonSerializer serializer = new JsonSerializer();
                        //serializer.Formatting =  
                        ShopConfigList = (List<ShopConfig>)serializer.Deserialize(file, typeof(List<ShopConfig>));
                        return ShopConfigList;
                    }
                    catch
                    {
                        return null;
                    }
                }
            }
            catch
            {
                return null;
            }
        }
    }

    /// <summary>
    /// 购物店主项配置表
    /// </summary>
    public class ShopConfig
    {
        /// <summary>
        /// 线路先把
        /// </summary>
        public int LineID
        {
            get;
            set;
        }

        /// <summary>
        /// 购物店子项列表
        /// </summary>
        public List<ShopConfigDetail> ChildList { get; set; }
    }

    /// <summary>
    /// 购物店子项配置表
    /// </summary>
    public class ShopConfigDetail
    {
        /// <summary>
        /// 购物店名称
        /// </summary>
        public string ShopName { get; set; }

        /// <summary>
        /// 购物店Id
        /// </summary>
        public int ShopId { get; set; }

        /// <summary>
        /// 资金池账户ID
        /// </summary>
        public int CashPoolID { get; set; }

        /// <summary>
        /// 费用类型
        /// </summary>
        public int CostTypeId { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public int CurrencyId { get; set; }
    }
}