﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 现金账户表仓储层
    /// </summary>
    public class RB_CashAccountRepository : BaseRepository<RB_CashAccount>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_CashAccount); } }

        /// <summary>
        /// 获取公司银行账户列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_CashAccount_Extend> GetList(RB_CashAccount_Extend model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND A." + nameof(RB_CashAccount.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND A." + nameof(RB_CashAccount.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (!string.IsNullOrWhiteSpace(model.AccountIdStr))
            {
                where += string.Format(" AND A." + nameof(RB_CashAccount.ID) + " in({0}) ", model.AccountIdStr);
            }
            if (model.TypeId > 0)
            {
                where += string.Format(" AND A." + nameof(RB_CashAccount.TypeId) + "={0} ", model.TypeId);
            }
            if (model.CurrencyId > 0)
            {
                where += string.Format(" AND A." + nameof(RB_CashAccount.CurrencyId) + "={0} ", model.CurrencyId);
            }
            if (!string.IsNullOrWhiteSpace(model.Alias))
            {
                where += string.Format(" AND A." + nameof(RB_CashAccount.Alias) + " like'%{0}%' ", model.Alias);
            }
            return Get<RB_CashAccount_Extend>(string.Format("SELECT A.*,C.`Name` as TypeName,D.`Name` as CurrencyName,D.Rate,D.CurrentRate as CurrencyRate,D.OutCashRate as PayRate,D.ExchangeRates,D.IsStandardCurrency as IsStandardCurrency FROM {0}  as A  left JOIN RB_AccountType as c ON A.TypeId = C.ID LEFT JOIN rb_currency as D ON D.ID = A.currencyID {1}", TableName, where)).ToList();
        }
    }
}
