﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Pay.WeChatPat
{
    /// <summary>
    /// 微信支付参数实体
    /// </summary>
    public class WeChatParam
    {
        /// <summary>
        /// 微信接入方式
        /// </summary>
        public WeChatType WeChatType { get; set; }

        #region 常用
        /// <summary>
        /// 微信OpenId
        /// </summary>
        public string OpenId { get; set; }

        /// <summary>
        /// UUID
        /// </summary>
        public string Unionid { get; set; }

        /// <summary>
        /// Token
        /// </summary>
        public string AccessToken { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string WeChatPublic { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public bool Debug { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Url { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Code { get; set; }
        #endregion
    }

    /// <summary>
    /// 微信接入方式
    /// </summary>
    public enum WeChatType
    {
        /// <summary>
        /// 公众号
        /// </summary>
        Public = 1,
        /// <summary>
        /// 开放平台
        /// </summary>
        Open = 2
    }
}
