﻿using Mall.Education.Models;
using RabbitMQ.Client;
using RabbitMQ.Client.Events;
using System;
using System.Text;
using Newtonsoft.Json;
using System.IO;
using Mall.Education.Offices;
using COSSnippet;
using Mall.Education.Helper;
using System.Collections.Generic;

namespace Mall.Education.RabbitMQ
{
    /// <summary>
    /// RabbitMq消息队列
    /// </summary>
    public static class RabbiMQManager
    {
        /// <summary>
        /// 获取连接
        /// </summary>
        /// <param name="rabbitConfig">连接配置实体</param>
        /// <returns></returns>
        private static ConnectionFactory GetConnectionFactory(RabbitConfig rabbitConfig)
        {
            ConnectionFactory factory = new ConnectionFactory
            {
                HostName = rabbitConfig.HostName,
                //默认端口
                Port = rabbitConfig.Port,
                UserName = rabbitConfig.UserName,
                Password = rabbitConfig.Password
            };
            return factory;
        }

        [Obsolete]
        public static void DealWithMessage(RabbitConfig rabbitConfig)
        {
            using (IConnection conn = GetConnectionFactory(rabbitConfig).CreateConnection())
            {
                using (IModel channel = conn.CreateModel())
                {
                    //在MQ上定义一个持久化队列，如果名称相同不会重复创建
                    channel.QueueDeclare(rabbitConfig.QueenName, true, false, false, null);
                    //输入1，那如果接收一个消息，但是没有应答，则客户端不会收到下一个消息
                    channel.BasicQos(0, 1, false);
                    //在队列上定义一个消费者
                    QueueingBasicConsumer consumer = new QueueingBasicConsumer(channel);
                    //消费队列，并设置应答模式为程序主动应答
                    channel.BasicConsume(rabbitConfig.QueenName, false, consumer);

                    while (true)
                    {
                        //阻塞函数，获取队列中的消息
                        BasicDeliverEventArgs ea = (BasicDeliverEventArgs)consumer.Queue.Dequeue();
                        byte[] bytes = ea.Body;
                        string msg = Encoding.UTF8.GetString(bytes);
                        try
                        {
                            var GoodsModel = JsonConvert.DeserializeObject<GoodsModel>(msg);
                            //处理
                            if (GoodsModel != null)
                            {
                                ImageConvertData(GoodsModel);
                            }
                            //Console.WriteLine(msg);
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine(ex.Message);
                        }
                        //回复确认
                        channel.BasicAck(ea.DeliveryTag, false);
                    }
                }
            }
        }

        /// <summary>
        /// 处理文件
        /// </summary>
        /// <param name="GoodsModel"></param>
        private static void ImageConvertData(GoodsModel GoodsModel)
        {
            string tempDir = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "tempfile/Image");
            if (!Directory.Exists(tempDir))
                Directory.CreateDirectory(tempDir);
            //是否需要先把文件下载到服务器
            GoodsModel.FilePath = "https://viitto-1301420277.cos.ap-chengdu.myqcloud.com/Test/Upload/Education/wkxq.docx";
            //文件生成图片暂存本地
            string FileExtension = Path.GetExtension(GoodsModel.FilePath);
            string FileName = Path.GetFileNameWithoutExtension(GoodsModel.FilePath);
            string FileDirectory = Path.GetDirectoryName(GoodsModel.FilePath);
            int PageNum;
            System.Drawing.Imaging.ImageFormat imageFormat = System.Drawing.Imaging.ImageFormat.Jpeg;
            if (FileExtension == ".doc" || FileExtension == ".docx")
            {
                new Word2ImageConverter().ConvertToImage(GoodsModel.FilePath, tempDir + "/", imageFormat, out PageNum);
            }
            else if (FileExtension == ".pdf")
            {
                new Pdf2ImageConverter().ConvertToImage(GoodsModel.FilePath, tempDir + "/", imageFormat, out PageNum);
            }
            else if (FileExtension == ".ppt" || FileExtension == ".pptx")
            {
                new Ppt2ImageConverter().ConvertToImage(GoodsModel.FilePath, tempDir + "/", imageFormat, out PageNum);
            }
            else {
                return;
            }

            if (PageNum > 0)
            {
                List<GoodsImage> goodsImages = new List<GoodsImage>();
                //开始上传图片至服务器
                TransferUploadObjectModel m = new TransferUploadObjectModel();
                for (var i = 1; i <= PageNum; i++)
                {
                    string newName = FileName + "_" + i.ToString("000") + "." + imageFormat.ToString();
                    m.TransferUploadFile(tempDir + "/" + newName, newName);

                    //上传之后 写入商品课程图片数据
                    goodsImages.Add(new GoodsImage
                    {
                        Sort = i,
                        Path = FileDirectory + "/" + newName
                    });
                }

                //更新图片数据
                bool flag = FileDataHelper.InsertGoodsFileImage(GoodsModel.CourseId, JsonConvert.SerializeObject(goodsImages)) > 0;
                if (flag == false) {
                    Console.WriteLine("更新课程图片列表失败：CourseId:" + GoodsModel.CourseId);
                }
            }
        }
    }
}
