﻿using Mall.Repository.Product;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using Mall.Model.Entity.Product;
using VT.FW.DB;

namespace Mall.WindowsService.Module
{
    /// <summary>
    /// 商品自动上架下架
    /// </summary>
    public class GoodsShelvesModule
    {
        /// <summary>
        /// 商品仓储层对象
        /// </summary>
        private static readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();

        /// <summary>
        /// 商品自动上架时间
        /// </summary>
        /// <returns></returns>
        public static bool ShelvesGoodsModule()
        {
            bool flag = false;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT Id,GoodsStatus,ShelvesDate,DownDate 
FROM rb_goods 
WHERE Status=0 AND '{0}'>=ShelvesDate AND '{0}'<=DownDate  AND GoodsStatus<>1  
", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

            var list = goodsRepository.Get<RB_Goods>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        {nameof(RB_Goods.GoodsStatus),1 }
                    };
                    flag = goodsRepository.Update(fileds, new WhereHelper(nameof(RB_Goods.Id), item.Id));
                }
            }
            return flag;
        }

        /// <summary>
        /// 商品自动下架
        /// </summary>
        /// <returns></returns>
        public static bool DownGoodsModule()
        {
            bool flag = false;
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT Id,GoodsStatus,ShelvesDate,DownDate 
FROM rb_goods 
WHERE Status=0 AND DownDate<='{0}' AND GoodsStatus=1 ", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

            var list = goodsRepository.Get<RB_Goods>(builder.ToString()).ToList();
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                        {nameof(RB_Goods.GoodsStatus),2 }
                    };
                    flag = goodsRepository.Update(fileds, new WhereHelper(nameof(RB_Goods.Id), item.Id));
                }
            }
            return flag;
        }
    }
}
